/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 01/03/2024
 */
 
#include "net.h"

namespace vampiria { namespace net {

void make_header(vmp::Buf *buf)
{
    vmp_size id=vmp::rand_wrap(vmp::time::time_wrap() % 10);
    buf->write_size(id,2);
    buf->write_size(0x0100,2);
    buf->write_size(1,2);
    buf->write_size(0,2);
    buf->write_size(0,2);
    buf->write_size(0,2);
}

void make_qname(vmp::Buf *buf,vmp::str host,vmp_size type)
{
    vmp_index j=0;
    vmp::str tmp="";
    for(vmp_index i=0;i<host.size();i++)
    {
        if(host[i] == '.')
        {
            buf->write_size(j,1);
            buf->write_str(tmp);
            j=0;
            tmp="";
            continue;
        
        }
        j++;
        tmp += host[i];
            
    }
    buf->write_size(j,1);
    buf->write_str(tmp);
    buf->write_byte(0x00);
    buf->write_size(type,2);
    buf->write_size(1,2);
}

void make_length(vmp::Buf *buf)
{
    vmp::Buf tmp;
    tmp.write_size(buf->size(),2);
    buf->cathead(&tmp);
}

vmp::str get_qname(vmp::Buf *buf)
{
    vmp::str tmp="",ret="";
    vmp_byte c=buf->read_byte();
    vmp_int i=(vmp_int)c;
    while(1)
    {
        c=buf->read_byte();
        if(c == 0x00)
        {
            ret += tmp;
            break;
        }
        if(i == 0)
        {
            i=(vmp_int)c;
            ret += tmp;
            ret += '.';
            tmp="";
        }
        else
        {
            tmp += c;
            i--;
        }
    }
    return ret.substr(0,ret.size());
}

vmp::vector<vmp::str> read_answers(vmp::Buf *buf,vmp_bool length)
{
    vmp::vector<vmp::str> ret;
    vmp_byte c;
    vmp::str tmp;
    net::Address address;
    try
    {
        if(length)
            buf->index(6);
        else
            buf->index(4);
        vmp_size questions=buf->read_size(2);
        vmp_size answers=buf->read_size(2);
        buf->index(buf->get_index()+4);
        for(vmp_index i=0;i<questions;i++)
        {
            do
            {
                c=buf->read_byte();   
            }
            while(c != 0x00);
            buf->index(buf->get_index()+4);
        }
        for(vmp_index i=0;i<answers;i++)
        {
            c=buf->read_byte();
            if((c & 0xC0) == 0xC0)   
                buf->read_byte();
            else
            {
                do
                {
                    c=buf->read_byte();   
                }
                while(c != 0x00);
            }
            vmp_size type=buf->read_size(2);
            vmp_size cl=buf->read_size(2);
            buf->index(buf->get_index()+6);
            if(cl == 0x01)
            {
                switch(type)
                {
                    case 1:
                        net::ipv4_from_buf(&address,buf);
                        ret.push_back(address.ip());
                        break;
                    case 15:
                        buf->read_size(2);
                        tmp=get_qname(buf);
                        if(tmp != "")
                            ret.push_back(tmp);
                        break;
                    case 28:
                        net::ipv6_from_buf(&address,buf);
                        ret.push_back(address.ip());
                    default:
                        break;
                }
            }
            
        }
    }
    catch(vmp::exception &x)
    {
    }
    return ret;
}

//!Internal usage
vmp_bool tcp_resolve(vmp::Buf *buf,vmp::str dnsip,vmp::str dnsport,vmp::time::Time timeout)
{
    vmp_int stream;
    if(net::is_ipv4_raw(dnsip))
        stream=AF_INET;
    else if(net::is_ipv6_raw(dnsip))
        stream=AF_INET6;
    else
        return false;
    net::Address dns;
    dns.set(dnsip,dnsport);
    net::Socket sock=net::socket_stream(stream,true);
    if(sock == -1)
        return false;
    try
    {
        if(net::socket_connect(sock,&dns) != 0)
            vmp::except_s("");
        if(net::socket_send(sock,buf) == -1)
           vmp::except_s("");
        net::socket_timeout(sock,timeout);
        if(net::socket_recv(sock,buf) == 0)
            vmp::except_s("");
    }
    catch(vmp::exception &x)
    {
        socket_close(&sock);
        return false;
    }
    socket_close(&sock);
    return true;
}

vmp::vector<vmp::str> tcp_resolve4(vmp::str host,vmp::str dnsip,vmp::str dnsport,vmp::time::Time timeout)
{
    vmp::vector<vmp::str> ret;
    vmp::Buf buf;
    net::make_header(&buf);
    net::make_qname(&buf,host,1);
    net::make_length(&buf);
    if(net::tcp_resolve(&buf,dnsip,dnsport,timeout))
        ret=net::read_answers(&buf,true);
    return ret;
}

vmp::vector<vmp::str> tcp_resolve6(vmp::str host,vmp::str dnsip,vmp::str dnsport,vmp::time::Time timeout)
{
    vmp::vector<vmp::str> ret;
    vmp::Buf buf;
    net::make_header(&buf);
    net::make_qname(&buf,host,28);
    net::make_length(&buf);
    if(net::tcp_resolve(&buf,dnsip,dnsport,timeout))
        ret=net::read_answers(&buf,true);
    return ret;    
}

vmp::vector<vmp::str> tcp_resolveMX(vmp::str host,vmp::str dnsip,vmp::str dnsport,vmp::time::Time timeout)
{
    vmp::vector<vmp::str> ret;
    vmp::Buf buf;
    net::make_header(&buf);
    net::make_qname(&buf,host,15);
    net::make_length(&buf);
    if(net::tcp_resolve(&buf,dnsip,dnsport,timeout))
        ret=net::read_answers(&buf,true);
    return ret;    
}

}}

