/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 28/10/2024
*/
 
#include "net.h"

namespace vampiria { namespace net {

void connection_tcp_accept(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    event::UI *ui=cell->ui<event::UI>();
    event::Cell *child;
    manager->lock();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {    
        vmp_int socket=net::socket_accept(conn->fd_,false);
        if(socket >= 0)
        {
            exec=manager->cell_update(cell);
            if(exec)
            {
                net::EventConnection *chevent=(net::EventConnection *) ui->child_event_new(cell);
                if(chevent == 0)
                    vmp::except("Fatal Error Tcp accept connection uninitilaizated ui->child_event_new()");
                chevent->conntype_=net::CONN_TCPSERVER;
                child=chevent->evt_new(ui,socket,net::connection_tcp_recv,conn->cchild_);
                chevent->parent_=cell;
                manager->cell_alloc(cell);
                child->evtype_=cell->evtype_;
                chevent->recv_=conn->recv_;
                chevent->send_=net::connection_tcp_send;
                if((net::socket_addrlocal(socket,&(chevent->local_)) == -1) || (net::socket_addrpeer(socket,&(chevent->peer_)) == -1))
                {
                    manager->cell_close_err_spec(child,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
                    exec=false;
                }
            }
        }
        else if(socket == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());
        exec=false;
    }
    manager->unlock();
    if(exec)
        conn->acptevent_(cell,child);
}

void connection_tcp_connect(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    manager->lock();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {
        vmp_int ret=net::socket_connect_check(conn->fd_);
        if(ret == 0)
        {
            if(net::socket_addrlocal(conn->fd_,&(conn->local_)) == -1)
                vmp::except_errno();
            cell->read_=net::connection_tcp_recv;
            cell->writing_=false;   
            exec=manager->cell_update(cell);
        }
        else if(ret == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());
    }
    manager->unlock();
    if(exec)
        conn->connect_(cell);
}

void connection_tcp_bind(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    manager->lock();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {    
        manager->cell_timewait(cell,0);
        vmp_int socket=net::socket_accept(conn->fd_,false);
        if(socket >= 0)
        {
            exec=manager->cell_update(cell);
            if(exec)
            {
                net::socket_close(&(conn->fd_));
                conn->fd_=socket;
                cell->read_=net::connection_tcp_recv;
                conn->send_=net::connection_tcp_send;
                if((net::socket_addrlocal(socket,&(conn->local_)) == -1) || (net::socket_addrpeer(socket,&(conn->peer_)) == -1))
                {
                    manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
                    exec=false;
                }
                if(conn->bindservice_.ip() != conn->peer_.ip())
                {
                    vmp::str err;
                    vmp::unicode::str_write(&err,"The connected peer host(%s) does not match the host(%s) of the associated service",conn->peer_.ip().c_str(),conn->bindservice_.ip().c_str());
                    manager->cell_close_err_spec(cell,"net::EventConnection",0,err);
                    exec=false;
                }
            }
        }
        else if(socket == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());
        exec=false;
    }
    manager->unlock();
    if(exec)
        conn->connect_(cell);
}

void connection_tcp_recv(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    vmp::Buf buf;
    manager->lock();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {
        vmp_int ret=net::socket_recv(conn->fd_,&buf);
        if(ret == 0)
            manager->cell_close_ok_spec(cell,"net::EventConnection");
        else if(ret > 0)
            exec=manager->cell_update(cell);
        else if(ret == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
            
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());
    }
    manager->unlock();
    if(exec)
        conn->recv_(cell,&buf);
    buf.reset();  
}

void connection_tcp_send(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
   event::Manager *manager=cell->get_manager();
   net::EventConnection *conn=cell->event<net::EventConnection>();
   if(net::socket_send(conn->fd_,buf) == -1)
       manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
}

}}

