/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 05/04/2024
 */

#ifndef VAMPIRIA_MODULES_MODPARSER_H

#define VAMPIRIA_MODULES_MODPARSER_H 1

namespace vampiria { namespace modules {

class ModDescTag:public xml::Tag
{
    public:
        ModDescTag();
        ~ModDescTag();

        void build();
};

class ModParTag:public xml::Tag
{
    private:
        virtual void build_impl()=0;
        virtual void check_impl(vmp::str par)=0;
    public:
        ModParTag();
        virtual ~ModParTag();
 
        vmp::str description_;

        void build();

        void check(vmp::str par);   
};

class ModParGeneric:public ModParTag
{
   private:
       void build_impl();
       void check_impl(vmp::str par); 
   public:
       ModParGeneric();
       ~ModParGeneric();
};

class ModOptDataTag:public xml::Tag
{
    public:
       ModOptDataTag();
       ~ModOptDataTag();

       void build();
};

class ModParOpt:public ModParTag
{
   private:
       void build_impl();
       void check_impl(vmp::str par);
   public:
       ModParOpt();
       ~ModParOpt();

       vmp::vector<vmp::str> opt_;
};

class ModParInteger:public ModParTag
{
   private:
       void build_impl();
       void check_impl(vmp::str par); 
   public:
       ModParInteger();
       ~ModParInteger();

       vmp_int min_;
       vmp_int max_;
};

class ModParReal:public ModParTag
{
   private:
       void build_impl();
       void check_impl(vmp::str par); 
   public:
       ModParReal();
       ~ModParReal();

       vmp_real min_;
       vmp_real max_;
};

class ModParHex:public ModParTag
{
   private:
       void build_impl();
       void check_impl(vmp::str par); 
   public:
       ModParHex();
       ~ModParHex();
};

class ModParIp:public ModParTag
{
   private:
       void build_impl();
       void check_impl(vmp::str par); 
   public:
       ModParIp();
       ~ModParIp();
};

class ModParMac:public ModParTag
{
   private:
       void build_impl();
       void check_impl(vmp::str par); 
   public:
       ModParMac();
       ~ModParMac();
};

class ModVarTag:public xml::Tag
{
    public:
        ModVarTag();
        ~ModVarTag();
 
        void build();   
};

class ModInputTag:public xml::Tag
{
    private:
        void destroy_impl();
    public:
        ModInputTag();
        ~ModInputTag();

        vmp::str name_;
        vmp::str required_;
        vmp_size minpar_;
        vmp::str description_;
        vmp_bool var_;
        vmp::str vardesc_;
        vmp::vector<modules::ModParTag *> par_;
        void build();

        vmp::str required_format();
};

class ModRootTag:public xml::Tag
{
    private:
        void destroy_impl();
    public:
        ModRootTag();
        ~ModRootTag();
 
        void build();

        vmp::str description_;
        vmp_bool run_;
        vmp::vector<modules::ModInputTag *> input_;
};

class ModInfo
{
    private:
      xml::Parser parser_;
    public:
      ModInfo(vmp::str manifest);
      ~ModInfo();

      modules::ModRootTag *get_root();
      vmp_bool executable();  
};

}}

#endif

