/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/03/2025
*/

#include "json.h"

namespace vampiria { namespace json {

void japi_login(json::JsonObj *obj,vmp::str user,vmp::str password,vmp_bool md5_password)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_login(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("login"));
    jdata.set_text("user",user);
    jdata.set_text("password",password);
    jdata.set_bool("md5_password",md5_password);  
}

vmp::str japi_login_b64_e(vmp::str user,vmp::str password,vmp_bool md5_password)
{
    json::Json j;
    json::japi_login(j.root(),user,password,md5_password);
    return vmp::unicode::b64_encode(j.json_str());
}

void japi_login_b64_d(json::Json *json,vmp::str etoken)
{
    vmp::except_check_pointer((void *) json,"json::japi_login_b64_d(json=Null)");    
    try
    {
        json::JData jdata;
        jdata.set(json->parse_from_str(vmp::unicode::b64_decode(etoken)));
        if(jdata.jtype() != json::japi("login"))
            vmp::except_s("");
    }
    catch(vmp::exception &x)
    {
        vmp::except("json::japi_login_b64_d(etoken=%s) bad value",etoken.c_str());
    }
}

void japi_passwd(json::JsonObj *obj,vmp::str oldpassword,vmp::str password,vmp_bool md5_password)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_passwd(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("passwd"));
    jdata.set_text("oldpassword",oldpassword);
    jdata.set_text("password",password);
    jdata.set_bool("md5_password",md5_password); 
}

void japi_userlist(json::JsonObj *obj)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_userlist(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("userlist"));
}

void japi_userinfo(json::JsonObj *obj,vmp::str user,vmp_uint permits,vmp_bool only_localhost)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_userinfo(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("userinfo"));
    jdata.set_text("user",user);
    jdata.set_integer_range("permits",0,vmp::INTMAX,(vmp_int)permits);
    jdata.set_bool("only_localhost",only_localhost);
}

void japi_useradd(json::JsonObj *obj,vmp::str user,vmp::str password,vmp_uint permits,vmp_bool only_localhost,vmp_bool md5_password)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_useradd(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("useradd"));
    jdata.set_text("user",user);
    jdata.set_text("password",password);
    jdata.set_integer_range("permits",0,vmp::INTMAX,(vmp_int)permits);
    jdata.set_bool("only_localhost",only_localhost);
    jdata.set_bool("md5_password",md5_password);
}

void japi_usermod(json::JsonObj *obj,vmp::str user,vmp_uint permits,vmp_bool only_localhost)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_usermod(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("usermod"));
    jdata.set_text("user",user);
    jdata.set_integer_range("permits",0,vmp::INTMAX,(vmp_int)permits);
    jdata.set_bool("only_localhost",only_localhost);
}

void japi_userpasswd(json::JsonObj *obj,vmp::str user,vmp::str password,vmp_bool md5_password)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_userpasswd(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("userpasswd"));
    jdata.set_text("user",user);
    jdata.set_text("password",password);
    jdata.set_bool("md5_password",md5_password);
}

void japi_userdel(json::JsonObj *obj,vmp::str user)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_userdel(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("userdel"));
    jdata.set_text("user",user);
}

}}

