/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/03/2025
*/

#ifndef VAMPIRIA_JSON_JAPI_PEER_H

#define VAMPIRIA_JSON_JAPI_PEER_H 1

namespace vampiria { namespace json {

//! Create a json data json::japi("peerlist") used for request list peers
/*!
    <pre>
    { 
       jtype: json::japi("peerlist"),
       jbody: 
       {
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @return void or except in case of failure
*/
void japi_peerlist(json::JsonObj *obj);

//! Create a json data json::japi("peerinfo") used for send userinfo data
/*!
    <pre>
    { 
       jtype: json::japi("peerinfo"),
       jbody: 
       {
           fingerprint:'fingerprint',
           subjetc:'subject',
           permits:permits
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param fingerprint fingerprint peer (read data json::jdata.get_text("fingerprint"))
    @param subject subject peer (read data json::jdata.get_text("subject"))
    @param permits permits peer (read data json::jdata.get_integer_range("permits",0,vmp::INTMAX))
    @return void or except in case of failure
*/
void japi_peerinfo(json::JsonObj *obj,vmp::str fingerprint,vmp::str subject,vmp_uint permits);

//! Create a json data json::japi("peeradd") used to add a peer node in the access table
/*!
    <pre>
    { 
       jtype: json::japi("peeradd"),
       jbody: 
       {
           fingerprint:'fingerprint',
           subject:'subject',
           permits:permits
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param fingerprint fingerprint peer (read data json::jdata.get_text("fingerprint"))
    @param subject subject peer (read data json::jdata.get_text("subject"))
    @param permits permits peer (read data json::jdata.get_integer_range("permits",0,vmp::INTMAX))
    @return void or except in case of failure
*/
void japi_peeradd(json::JsonObj *obj,vmp::str fingerprint,vmp::str subject,vmp_uint permits);

//! Create a json data json::japi("peermod") used to modify a peer node in the access table
/*!
    <pre>
    { 
       jtype: json::japi("peermod"),
       jbody: 
       {
           fingerprint:'fingerprint',
           permits:permits
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param fingerprint fingerprint peer (read data json::jdata.get_text("fingerprint"))
    @param permits permits peer (read data json::jdata.get_integer_range("permits",0,vmp::INTMAX))
    @return void or except in case of failure
*/
void japi_peermod(json::JsonObj *obj,vmp::str fingerprint,vmp_uint permits);

//! Create a json data json::japi("peerdel") used to delete a peer node in the access table
/*!
    <pre>
    { 
       jtype: json::japi("peerdel"),
       jbody: 
       {
           fingerprint:'fingerprint',
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param fingerprint fingerprint peer (read data json::jdata.get_text("fingerprint"))
    @return void or except in case of failure
*/
void japi_peerdel(json::JsonObj *obj,vmp::str fingerprint);

}}

#endif


