/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/03/2025
*/

#include "json.h"

namespace vampiria { namespace json {

void japi_peerlist(json::JsonObj *obj)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_peerlist(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("peerlist"));
}

void japi_peerinfo(json::JsonObj *obj,vmp::str fingerprint,vmp::str subject,vmp_uint permits)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_peerinfo(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("peerinfo"));
    jdata.set_text("fingerprint",fingerprint);
    jdata.set_text("subject",subject);
    jdata.set_integer_range("permits",0,vmp::INTMAX,(vmp_int)permits);
}

void japi_peeradd(json::JsonObj *obj,vmp::str fingerprint,vmp::str subject,vmp_uint permits)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_peeradd(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("peeradd"));
    jdata.set_text("fingerprint",fingerprint);
    jdata.set_text("subject",subject);
    jdata.set_integer_range("permits",0,vmp::INTMAX,(vmp_int)permits);
}

void japi_peermod(json::JsonObj *obj,vmp::str fingerprint,vmp_uint permits)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_peermod(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("peermod"));
    jdata.set_text("fingerprint",fingerprint);
    jdata.set_integer_range("permits",0,vmp::INTMAX,(vmp_int)permits);
}

void japi_peerdel(json::JsonObj *obj,vmp::str fingerprint)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_peerdel(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("peerdel"));
    jdata.set_text("fingerprint",fingerprint);
}

}}

