/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/03/2025
*/

#ifndef VAMPIRIA_JSON_JAPI_MISC_H

#define VAMPIRIA_JSON_JAPI_MISC_H 1

namespace vampiria { namespace json {

//! Create a json data json::japi("status") used to request information about your status at a process
/*!
    <pre>
    { 
       jtype: json::japi("status"),
       jbody: 
       {
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @return void or except in case of failure
*/
void japi_status(json::JsonObj *obj);

//! Create a json data json::japi("statusupdate") used to inform that a status variable has changed in the process
/*!
    <pre>
    { 
       jtype: json::japi("statusupdate"),
       jbody: 
       {
           key:'key',
           data:{json data object}
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param key key of the updated object (read data json::jdata.get_text("key"))
    @param data value of the updated object (read data json::jdata.get_subtype("data"))
    @return void or except in case of failure
*/
void japi_status_update(json::JsonObj *obj,vmp::str key,json::JsonObj *data);

//! Create a json data json::japi("statuscancel") used to inform that a status variable has been deleted
/*!
    <pre>
    { 
       jtype: json::japi("statuscancel"),
       jbody: 
       {
           key:'key',
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param key key of the deleted object (read data json::jdata.get_text("key"))
    @return void or except in case of failure
*/
void japi_status_cancel(json::JsonObj *obj,vmp::str key);

//! Create a json data json::japi("connectlist") used for to request the list of connections
/*!
    <pre>
    { 
       jtype: json::japi("connectlist"),
       jbody: 
       {
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @return void or except in case of failure
*/
void japi_connectlist(json::JsonObj *obj);

//! Create a json data json::japi("connectinfo") used for send connectinfo data
/*!
    <pre>
    { 
       jtype: json::japi("connectinfo"),
       jbody: 
       {
           id:'connection id',
           type:'connection type (p2p or wss)',
           permits:permits
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param id connect id (read data json::jdata.get_text("id"))
    @param type connect type (read data json::jdata.get_text("type"))
    @param aux auxiliary data(read data json::jdata.get_text("aux"))
    @param permits permits peer (read data json::jdata.get_integer_range("permits",0,vmp::INTMAX))
    @param address source address peer (read data json::jdata.get_text("address"))
    @param address source port address peer (read data json::jdata.get_integer_range("port",0,65535),0 port not setting)
    @return void or except in case of failure
*/
void japi_connectinfo(json::JsonObj *obj,vmp::str id,vmp::str type,vmp::str aux,vmp_uint permits,vmp::str address,vmp_uint port);

//! Create a json data json::japi("connectclose") used for to request the closure of a connection
/*!
    <pre>
    { 
       jtype: json::japi("connectclose"),
       jbody: 
       {
           id:'connection id',
           type:'connection type (p2p or wss)',
       }
    }
    </pre>
    @param obj object where the json data is inserted
    @param id connect id (read data json::jdata.get_text("id"))
    @param type connect type (read data json::jdata.get_text("type"))
    @return void or except in case of failure
*/
void japi_connectclose(json::JsonObj *obj,vmp::str id,vmp::str type);
}}

#endif

