/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/03/2025
*/

#include "json.h"

namespace vampiria { namespace json {

void japi_status(json::JsonObj *obj)
{
    vmp::except_check_pointer((void *) obj,"json::japi_status(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("status"));
}

void japi_status_update(json::JsonObj *obj,vmp::str key,json::JsonObj *data)
{
    vmp::except_check_pointer((void *) obj,"json::japi_status_update(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("statusupdate"));
    jdata.set_text("key",key);
    jdata.set_subtype("data",data);
}

void japi_status_cancel(json::JsonObj *obj,vmp::str key)
{
    vmp::except_check_pointer((void *) obj,"json::japi_status_cancel(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("statuscancel"));
    jdata.set_text("key",key);
}

void japi_connectlist(json::JsonObj *obj)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_connectlist(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("connectlist"));
}

void japi_connectinfo(json::JsonObj *obj,vmp::str id,vmp::str type,vmp::str aux,vmp_uint permits,vmp::str address,vmp_uint port)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_connectinfo(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("connectinfo"));
    jdata.set_text("id",id);
    jdata.set_text("type",type);
    jdata.set_text("aux",aux);
    jdata.set_integer_range("permits",0,vmp::INTMAX,(vmp_int)permits);
    jdata.set_text("address",address);
    jdata.set_integer_range("port",0,65535,port);
}

void japi_connectclose(json::JsonObj *obj,vmp::str id,vmp::str type)
{
    vmp::except_check_pointer((void *) obj,"web::pkg::japi_connectclose(obj=Null)");
    json::JData jdata;
    jdata.new_data(obj,json::japi("connectclose"));
    jdata.set_text("id",id);
    jdata.set_text("type",type);
}

}}

