/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 07/01/2025
*/

#ifndef VAMPIRIA_JRP_MISC_UTILS_H

#define VAMPIRIA_JRP_MISC_UTILS_H 1

namespace vampiria { namespace jrp { namespace misc {

//! Class used for handling messages to change a web user's password
class Passwd:public jrp::misc::JrpApi_I
{
    private:
        crypto::Ctx_Peer_Web *ctx_;/*!<Context peer web associated */
    public:
        //! A Constructor
        /*!
            @param ctx context peer web associated
        
        */
        Passwd(crypto::Ctx_Peer_Web *ctx);
        
        //! A Destructor
        ~Passwd();
        
        //! virtual function
        void register_common(jrp::JrpCommon *common,vmp::str permits="*");
        
        //! virtual function
        void management_impl(jrp::JrpReq *jreq,vmp::Buf *payload);
};

//! Class used for used for user management
class User:public jrp::misc::JrpApi_I
{
    private:
        crypto::Ctx_Peer_Web *ctx_;/*!<Context peer web associated */
    public:
        //! A Constructor
        /*!
            @param ctx context peer web associated
        
        */
        User(crypto::Ctx_Peer_Web *ctx);
        
        //! A Destructor
        ~User();

        //! virtual function
        void register_common(jrp::JrpCommon *common,vmp::str permits="*");
        
        //! virtual function
        void management_impl(jrp::JrpReq *jreq,vmp::Buf *payload);
};
//! Class used for used for peer management
class Peer:public jrp::misc::JrpApi_I
{
    private:
        crypto::Ctx_Peer *ctx_;/*!<Context peer associated */    
    public:
        //! A Constructor
        /*!
            @param ctx context peer web associated
        
        */
        Peer(crypto::Ctx_Peer *ctx);
        
        //! A Destructor
        ~Peer();
        
        //! virtual function
        void register_common(jrp::JrpCommon *common,vmp::str permits="*");
        
        //! virtual function
        void management_impl(jrp::JrpReq *jreq,vmp::Buf *payload);
};
//! Class used for connection management
class ConnectStatus:public jrp::misc::JrpApi_I
{
    private:
        jrp::JrpUI *jrpui_;/*!<User interface peer jrp associated*/
        jrp::WssJrpUI *wssjrpui_;/*!<User interface websocket jrp  associated*/
    public:
        //! A constructor
        /*!
            @param jrpui User interface peer jrp or null if not management
            @param jrpui User interface websocket jrp or null if not management
        */
        ConnectStatus(jrp::JrpUI *jrpui,jrp::WssJrpUI *wssjrpui);
        
        //! A destructor
        ~ConnectStatus();
        
        //! virtual function
        void register_common(jrp::JrpCommon *common,vmp::str permits="*");
        
        //! virtual function
        void management_impl(jrp::JrpReq *jreq,vmp::Buf *payload);
};

}}}

#endif
