/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/03/2025
*/

#include "jrp.h"

namespace vampiria { namespace jrp { namespace misc {

JrpApi_I::JrpApi_I()
{
}

JrpApi_I::~JrpApi_I()
{
    types_.clear();
}

void JrpApi_I::addtype(vmp::str type)
{
    types_.push_back(type);
}

vmp_bool JrpApi_I::management(jrp::JrpReq *jreq,vmp::Buf *payload)
{
    mutex_.lock();
    if((jreq != 0) && vmp::invector<vmp::str>(jreq->jdata_type(),types_))
    {
        management_impl(jreq,payload);
        mutex_.unlock();
        return true;
    }
    mutex_.unlock();
    return false;
}

void JrpApi_I::management_impl(jrp::JrpReq *jreq,vmp::Buf *payload)
{
}

vmp_bool JrpApi_I::management_response(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload)
{
    mutex_.lock();
    if((jreq != 0) && vmp::invector<vmp::str>(jreq->jdata_type(),types_))
    {
        management_response_impl(jreq,jdata,payload);
        mutex_.unlock();
        return true;
    }
    mutex_.unlock();
    return false;
}

void JrpApi_I::management_response_impl(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload)
{
}

vmp_bool JrpApi_I::management_push(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload)
{
    mutex_.lock();
    if((jreq != 0) && vmp::invector<vmp::str>(jreq->jdata_type(),types_))
    {
        management_push_impl(jreq,jdata,payload);
        mutex_.unlock();
        return true;
    }
    mutex_.unlock();
    return false;
}

void JrpApi_I::management_push_impl(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload)
{
}

vmp_bool JrpApi_I::management_kill(jrp::JrpReq *jreq)
{
    mutex_.lock();
    if((jreq != 0) && vmp::invector<vmp::str>(jreq->jdata_type(),types_))
    {
        management_kill_impl(jreq);
        mutex_.unlock();
        return true;
    }
    mutex_.unlock();
    return false;
}

void JrpApi_I::management_kill_impl(jrp::JrpReq *jreq)
{
}

vmp_bool JrpApi_I::management_close(jrp::JrpReq *jreq)
{
    mutex_.lock();
    if((jreq != 0) && vmp::invector<vmp::str>(jreq->jdata_type(),types_))
    {
        management_close_impl(jreq);
        mutex_.unlock();
        return true;
    }
    mutex_.unlock();
    return false;
}

void JrpApi_I::management_close_impl(jrp::JrpReq *jreq)
{
}

}}}

