/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 14/01/2025
*/

#include "jrp.h"

namespace vampiria { namespace jrp {

void jrp_recv_server(event::Cell *cell,vmp::Buf *buf)
{
    jrp::MsgParse msg;
    vmp_int ret;
    vmp_index rid;
    vmp::str exitmsg;
    jrp::JrpReq *req,*tmp;
    json::JsonObj obj;
    vmp_bool res;
    event::Manager *manager=cell->get_manager();
    ret=parse(buf,&msg);
    jrp::EventJrp *jrp=(jrp::EventJrp *)cell->event<crypto::EventSsl>()->sub_;
    if(ret == jrp::status_ok)
    {
        try
        {
            if(msg.msgtype_ == "request")
            {
                req=jrp->common_->recv_request(&msg,cell);
                if(req == 0)
                {
                    manager->lock();
                    jrp->evtsub_jrp_close(jrp::status_request_overflow);
                    manager->unlock();
                }
                rid=req->rid();
                if(jrp->srvreq_.search(rid,&tmp))
                {
                    manager->lock();
                    jrp->evtsub_jrp_close(jrp::status_rid_duplex);
                    manager->unlock();
                
                }
                else if(!jrp->common_->session_.match_reqdata(req->jdata_type(),jrp->sessionpermits_))
                {
                    exitmsg=jrp::msg_status(jrp::status_resource_accessdenied);
                    jrp->common_->requesterrcb_(req,jrp::status_resource_accessdenied,exitmsg);
                    manager->lock();
                    jrp->evtsub_jrp_close(jrp::status_rid_duplex,exitmsg);
                    manager->unlock();
                }
                else
                {
                   manager->lock();
                   jrp->srvreq_.insert(rid,req); 
                   manager->unlock();
                   jrp->common_->requestcb_(req,&msg.payload_);
                }
            }
            else if(msg.msgtype_ == "push")
            {
                manager->lock();
                res=jrp->srvreq_.search(msg.rid_,&req);
                manager->unlock();
                if(res)
                {
                    for(vmp_index i=0;i<msg.outputs_.get_array_size();i++)
                    {
                        msg.outputs_.get_array_idx(i,&obj);
                        jrp->common_->pushcb_(req,&obj,&msg.payload_);
                    }
                }
            }
            else if(msg.msgtype_ == "kill")
            {
               manager->lock();
               res=jrp->srvreq_.search(msg.rid_,&req);
               manager->unlock();
               if(res)
                   jrp->common_->killcb_(req);
            }
            else if(msg.msgtype_ == "broadcast")
            {
                json::JData jdata;
                jdata.set(&msg.input_);
                if(jrp->common_->session_.match_bdata(jdata.jtype()))
                    jrp->common_->broadcastcb_(cell,&msg.input_,&msg.payload_);
            }
            else
            {
                manager->lock();
                jrp->evtsub_jrp_close(jrp::status_protocolbad);
                manager->unlock();
            }
        }
        catch(vmp::exception &x)
        {
            manager->lock();
            jrp->evtsub_jrp_close(jrp::status_err,x.what());
            manager->unlock();
        }
    }
    else
    {
        manager->unlock();
        jrp->evtsub_jrp_close(ret);
        manager->unlock();
    }
}

void jrp_recv_peer(event::Cell *cell,vmp::Buf *buf)
{
    jrp::MsgParse msg;
    vmp_int ret;
    vmp_index rid;
    vmp::str exitmsg;
    jrp::JrpReq *req,*tmp;
    json::JsonObj obj;
    vmp_bool res;
    event::Manager *manager=cell->get_manager();
    ret=parse(buf,&msg);
    jrp::EventJrp *jrp=(jrp::EventJrp *)cell->event<crypto::EventSsl>()->sub_;
    if(ret == jrp::status_ok)
    {
        try
        {
            if(msg.msgtype_ == "request")
            {
                req=jrp->common_->recv_request(&msg,cell);
                if(req == 0)
                {
                    manager->lock();
                    jrp->evtsub_jrp_close(jrp::status_request_overflow);
                    manager->unlock();
                }
                else
                {
                    rid=req->rid();
                    if(jrp->srvreq_.search(rid,&tmp))
                    {
                        manager->lock();
                        jrp->evtsub_jrp_close(jrp::status_rid_duplex);
                        manager->unlock();
                    }
                    else if(!jrp->common_->session_.match_reqdata(req->jdata_type(),jrp->sessionpermits_))
                    {
                        exitmsg=jrp::msg_status(jrp::status_resource_accessdenied);
                        jrp->common_->requesterrcb_(req,jrp::status_resource_accessdenied,exitmsg);
                        manager->lock();
                        jrp->evtsub_jrp_close(jrp::status_rid_duplex,exitmsg);
                        manager->unlock();
                    }
                    else
                    {
                        manager->lock();
                        jrp->srvreq_.insert(rid,req); 
                        manager->unlock();
                        jrp->common_->requestcb_(req,&msg.payload_);
                    }
                }
            }
            else if(msg.msgtype_ == "push")
            {
                manager->lock();
                res=jrp->srvreq_.search(msg.rid_,&req);
                manager->unlock();
                if(res)
                {
                    for(vmp_index i=0;i<msg.outputs_.get_array_size();i++)
                    {
                        msg.outputs_.get_array_idx(i,&obj);
                        jrp->common_->pushcb_(req,&obj,&msg.payload_);
                    }
                }
            }
            else if(msg.msgtype_ == "response")
            {
                manager->lock();
                res=jrp->cltreq_.search(msg.rid_,&req);
                manager->unlock();
                if(res)
                {
                    for(vmp_index i=0;i<msg.outputs_.get_array_size();i++)
                    {
                        msg.outputs_.get_array_idx(i,&obj);
                        jrp->common_->responsecb_(req,&obj,&msg.payload_);
                    }
                }
            }
            else if(msg.msgtype_ == "close")
            {
                res=true;
                manager->lock();
                try
                {
                    jrp->cltreq_.cancel(msg.rid_,&req);
                }
                catch(vmp::exception &x)
                {
                    res=false;
                }
                if(res)
                {
                    req->recv_close(msg.status_,msg.msg_);
                    manager->unlock();
                    jrp->common_->closecb_(req);
                    req->release();
                }
                else
                    manager->unlock();
            }
            else if(msg.msgtype_ == "kill")
            {
                manager->lock();
                res=jrp->srvreq_.search(msg.rid_,&req);
                manager->unlock();
                if(res)
                    jrp->common_->killcb_(req);
            }
            else if(msg.msgtype_ == "broadcast")
            {
                json::JData jdata;
                jdata.set(&msg.input_);
                if(jrp->common_->session_.match_bdata(jdata.jtype()))
                   jrp->common_->broadcastcb_(cell,&msg.input_,&msg.payload_);
            }
            else
            {
                manager->lock();
                jrp->evtsub_jrp_close(jrp::status_protocolbad);
                manager->unlock();
            }
        }
        catch(vmp::exception &x)
        {
            manager->lock();
            jrp->evtsub_jrp_close(jrp::status_err,x.what());
            manager->unlock();
        }
    }
    else
    {
        manager->unlock();
        jrp->evtsub_jrp_close(ret);
        manager->unlock();
    }
}

void jrp_close_server(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    jrp::EventJrp *jrp=(jrp::EventJrp *)cell->event<crypto::EventSsl>()->sub_;
    vmp::vector<jrp::JrpReq *> csrvs=jrp->srvreq_.all_data();
    jrp->srvreq_.clear();
    manager->unlock();
    for(vmp_index i=0;i<csrvs.size();i++)
    {
        try
        {
            jrp->common_->killcb_(csrvs[i]);   
        }
        catch(vmp::exception &x)
        {
        }
        csrvs[i]->release();
    }
}

void jrp_close_peer(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    jrp::EventJrp *jrp=(jrp::EventJrp *)cell->event<crypto::EventSsl>()->sub_;
    vmp::vector<jrp::JrpReq *> csrvs=jrp->srvreq_.all_data();
    jrp->srvreq_.clear();
    vmp::vector<jrp::JrpReq *> creqs=jrp->cltreq_.all_data();
    jrp->cltreq_.clear();
    manager->unlock();
    for(vmp_index i=0;i<csrvs.size();i++)
    {
        try
        {
            jrp->common_->killcb_(csrvs[i]);   
        }
        catch(vmp::exception &x)
        {
        }
        csrvs[i]->release();
    }
    for(vmp_index i=0;i<creqs.size();i++)
    {
        try
        {
            jrp->common_->closecb_(creqs[i]);
        }
        catch(vmp::exception &x)
        {
        }
        creqs[i]->release();
    }
}

}}

