/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 04/03/2025
 */
 
#ifndef VAMPIRIA_CRYPTO_CTX_H

#define VAMPIRIA_CRYPTO_CTX_H 1

namespace vampiria { namespace crypto {

//!Class used as container of context openssl(see SSL_CTX *)
class Ctx
{
    public:
        Ctx();

        //! A destructor
        ~Ctx();
        
        SSL_CTX *ctx_;/*!< Context openssl*/ 
 
        //!Reset structure     
        void reset();
        
        //! Copy the value from the input ctx,and increments ctx_ references
        /*!
            @param ctx input context
            @return void or except in case of failure
        */
        void copy(crypto::Ctx *ctx);
        
        //! Gets certificate associated with the context
        /*!
            @param cout certificate output
            @return void or except in case failure
        */
        void get_x509(crypto::X509_Wrap *cout);
};

//! Virtual class to implement ssl contexts
class Ctx_I
{
    protected:
        crypto::Ctx ctx_;/*!<context associated*/
        
        //!Constructs the context via the init function, it is usually called in the constructor of the derived class after the parameters are initialized
        void build_ctx();
        
        //!Builds the context (virtual)
        /*!
            @return Context library ssl format
        */
        virtual SSL_CTX *init()=0;
    public:
        //! A costructor
        Ctx_I();
        
        //! A destructor
        virtual ~Ctx_I();
        
        //! Gets context associated with the class
        /*!
            @sa ctx_
            @return context or except in case failure
        */
        crypto::Ctx *get();
};

}}

#endif

#include "ctx/base.h"
#include "ctx/https.h"
#include "ctx/peer.h"



