/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 21/01/2025
 */
 
#ifndef VAMPIRIA_CRYPTO_CB_H

#define VAMPIRIA_CRYPTO_CB_H 1

namespace vampiria { namespace crypto {

//! Internal usage(sslcb.cc)
void ssl_tcp_connect(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_tcp_accept(event::Cell *cell,event::Cell *child);

//! Internal usage(sslcb.cc)
void ssl_ssl_connect(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_ssl_accept(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_ssl_shutdown(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_ssl_crecv(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_ssl_srecv(event::Cell *cell);

//! Internal usage,setting for connection send (sslcb.cc)
void ssl_send(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage,setting for ssl send (sslcb.cc)
void ssl_sslsend(event::Cell *cell,vmp::Buf *buf);

//! Internal usage,setting for ssl send in framing bin  mode (sslcb.cc)
void ssl_sslsend_framing(event::Cell *cell,vmp::Buf *buf);

//! Internal usage(sslcb.cc)
void ssl_routine_key(void *ref);

//! Internal usage(sslcb.cc)
void ssl_subprotocols_recv(event::Cell *cell,vmp::Buf *buf);

//! Internal usage(sslcb.cc)
void ssl_close_client(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_close_server(event::Cell *cell);

//! Internal usage(framing.cc)
void framing_recv_default(event::Cell *cell,vmp::Buf *buf);

//! Internal usage(framing.cc)
void framing_ping(void *ref);

//! Internal usage(framing.cc)
void framing_read(event::Cell *cell);

//! Internal usage(p2pcb.cc)
void p2psession(event::Cell *cell);

//! Internal usage(p2pcb.cc)
void p2psession_recv(event::Cell *cell,vmp::Buf *buf);

//! Internal usage(wsscb.cc)
void wss_tcpaccept(event::Cell *cell,event::Cell *child);

//! Internal usage(wsscb.cc)
void wss_auth_default(event::Cell *cell,json::JData *auth);

//! Internal usage(wsscb.cc)
void wssrecv_http(event::Cell *cell,vmp::Buf *buf);

}}

#endif

