/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 13/08/2024
*/
 
#include "rawnet_.h"

class PyArp4UI:public rawnet::Arp4UI
{
   public:
        PyArp4UI(event::Manager *manager,packet::PacketHelper *helper,vmp::str ifname);
        ~PyArp4UI();

        pylib::PyCall pyarprecv_;
        pylib::PyCall pycarp_;
};

PyArp4UI::PyArp4UI(event::Manager *manager,packet::PacketHelper *helper,vmp::str ifname):rawnet::Arp4UI(manager,helper,ifname)
{
}

PyArp4UI::~PyArp4UI()
{
}

struct stub_arp4ui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PyArp4UI *>(cell->ui<PyArp4UI>(),false);
        }
        return 0;
    }
};

struct Arp4UI_Constructor:public pylib::Constructor<PyArp4UI>
{
    PyArp4UI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 3)
         {
              event::Manager *manager=args.get<event::Manager *>(0);
              packet::PacketHelper *helper=args.get<packet::PacketHelper *>(1);
              vmp::str ifname=args.get<vmp::str>(2);
              return new PyArp4UI(manager,helper,ifname);
         }
         return 0;
    }
};

void arp4ui_pyarprecv(event::Cell *cell,vmp::str name,packet::Packet *packet)
{
    PyArp4UI *arp4ui=cell->ui<PyArp4UI>();
    pylib::CArgs cargs(3);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::str>(name);
    cargs.add<packet::Packet *>(packet,false);
    arp4ui->pyarprecv_.call(cargs);
}

void arp4ui_pycarp(event::Cell *cell)
{
    PyArp4UI *arp4ui=cell->ui<PyArp4UI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    arp4ui->pycarp_.call(cargs);
}

struct stub_Arp4UI_set_event:public pylib::Member_def<PyArp4UI>
{
    pylib::Objref *def(PyArp4UI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            rawnet::EVTRAWPKGCB arprecv;
            event::EVTCB carp;

            args.get_callable(0,instance->pyarprecv_);
            args.get_callable(1,instance->pycarp_);
            
            if(pylib::is_none(instance->pyarprecv_.ref()))
                arprecv=0;
            else 
                arprecv=arp4ui_pyarprecv;
            if(pylib::is_none(instance->pycarp_.ref()))
                carp=0;
            else 
                carp=arp4ui_pycarp;
            instance->set_event(arprecv,carp);
            return pylib::retnone();                      
        }
        return 0;
    }
};

struct stub_Arp4UI_start:public pylib::Member_def<PyArp4UI>
{
    pylib::Objref *def(PyArp4UI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() ==1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            instance->start(cell);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            vmp::time::Time timeval=args.get<vmp::time::Time>(1);
            instance->start(cell,timeval);
            return pylib::retnone(); 
        }
        return 0;
    }
};

void rawnet_arpui(pylib::Module module)
{
    //Wrapper cell->ui()
    module.def_with_stub("arp4ui",stub_arp4ui());
    
    pylib::Class<PyArp4UI> arp4ui=module.class_with_constructor<PyArp4UI>("Arp4UI",Arp4UI_Constructor());
    arp4ui.def_with_stub("set_event",stub_Arp4UI_set_event());
    arp4ui.def_("arp4evt",&PyArp4UI::arp4evt,false);
    arp4ui.def_with_stub("start",stub_Arp4UI_start());
    arp4ui.def_("stop",&PyArp4UI::stop);
    arp4ui.def_("inject",&PyArp4UI::inject);
    arp4ui.def_("add_sniffer",&PyArp4UI::add_sniffer,false);
    arp4ui.def_("start_sniffer",&PyArp4UI::start_sniffer);
    arp4ui.def_("ifname",&PyArp4UI::ifname);
    arp4ui.def_("ifname_ip",&PyArp4UI::ifname_ip);
    arp4ui.def_("ifname_mac",&PyArp4UI::ifname_mac);
    arp4ui.def_("ipsrc",&PyArp4UI::ipsrc);
    arp4ui.def_("macsrc",&PyArp4UI::macsrc);
    arp4ui.def_("targets",&PyArp4UI::targets);
}


