#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 05/09/2024

##@package vmp_packet
#
# Wrapper c++ namespace vampiria::packet

import vmp

from vmp_packet_ import  P_RAW           as  P_RAW
from vmp_packet_ import  P_ETHERNET      as  P_ETHERNET
from vmp_packet_ import  P_ARP           as  P_ARP
from vmp_packet_ import  P_IPV4          as  P_IPV4
from vmp_packet_ import  P_UDP           as  P_UDP
from vmp_packet_ import  P_TCP           as  P_TCP

from vmp_packet_ import  packet_free            as packet_free
from vmp_packet_ import  arpsub_str_generic     as arpsub_str_generic
from vmp_packet_ import  Ipv4_integrity_check   as Ipv4_integrity_check
from vmp_packet_ import  Ipv4_adjust_check      as Ipv4_adjust_check
from vmp_packet_ import  Tcp_integrity_check    as Tcp_integrity_check
from vmp_packet_ import  Tcp_adjust_check       as Tcp_adjust_check
from vmp_packet_ import  Udp_integrity_check    as Udp_integrity_check
from vmp_packet_ import  Udp_adjust_check       as Udp_adjust_check

from vmp_packet_ import  ethertype_str_generic  as ethertype_str_generic
from vmp_packet_ import  ipproto_str_generic    as ipproto_str_generic
from vmp_packet_ import  arphtype_str_generic   as arphtype_str_generic  

from vmp_packet_ import  Packet           as  Packet
from vmp_packet_ import  PacketHelper     as  PacketHelper

from vmp_packet_ import  Arp_Ethernet_Ipv4_D as Arp_Ethernet_Ipv4_D
from vmp_packet_ import  Ethernet_D          as Ethernet_D
from vmp_packet_ import  Ipv4_D              as Ipv4_D
from vmp_packet_ import  Raw_D               as Raw_D
from vmp_packet_ import  Tcp_D               as Tcp_D
from vmp_packet_ import  Udp_D               as Udp_D

from .           import  http                as http
from .           import  websocket           as websocket

##see c++ comment
def Arp_Ethernet_Ipv4(oper="request",sha="00:00:00:00:00:00",spa="0.0.0.0",tha="FF:FF:FF:FF:FF:FF",tpa="255.255.255.255"):
  p=Arp_Ethernet_Ipv4_D()
  try:
    p.set("oper",oper)
    p.set("sha",sha)
    p.set("spa",spa)
    p.set("tha",tha)
    p.set("tpa",tpa)
  except Exception as e:
    packet_free(p)
    vmp.except_s(str(e))
  return p

##see c++ comment  
def Ethernet(dstmac="FF:FF:FF:FF:FF:FF",srcmac="00:00:00:00:00:00",ethertype=ethertype_str_generic(0)):
  p=Ethernet_D()
  try:
    p.set("dstmac",dstmac)
    p.set("srcmac",srcmac)
    p.set("ethertype",ethertype)
  except Exception as e:
    packet_free(p)
    vmp.except_s(str(e))
  return p

##see c++ comment
def Ipv4(total_length="20",identification="0",ttl="1",protocol=ipproto_str_generic(0),source="0.0.0.0",destination="255.255.255.255",options=""):
  p=Ipv4_D()
  try:
    p.set("total_length",total_length)
    p.set("identification",identification)
    p.set("ttl",ttl)
    p.set("protocol",protocol)
    p.set("source",source)
    p.set("destination",destination)
    p.set("options",options)
  except Exception as e:
    packet_free(p)
    vmp.except_s(str(e))
  return p

##see c++ comment
def Tcp(srcport="10000",dstport="10001",sequence_n="0",ack_n="0",cwr="unset",ece="unset",urg="unset",ack="unset",psh="unset",
        rst="unset",syn="unset",fin="unset",window="0",urgent_p="0",options=""):
  p=Tcp_D()
  try:
    p.set("srcport",srcport)
    p.set("dstport",dstport)
    p.set("sequence_n",sequence_n)
    p.set("ack_n",ack_n)
        
    p.set("cwr",cwr)
    p.set("ece",ece)
    p.set("urg",urg)
    p.set("ack",ack)
    p.set("psh",psh)
    p.set("rst",rst)
    p.set("syn",syn)
    p.set("fin",fin)

    p.set("window",window)
    p.set("urgent_p",urgent_p)
    p.set("options",options)
  except Exception as e:
    packet_free(p)
    vmp.except_s(str(e))
  return p

##see c++ comment
def Udp(srcport="10000",dstport="10001"):
  p=Udp_D()
  try:
    p.set("srcport",srcport)
    p.set("dstport",dstport)
  except Exception as e:
    packet_free(p)
    vmp.except_s(str(e))
  return p

##see c++ comment
def Raw(data=""):
  p=Raw_D()
  try:
    p.set("data",data)
  except Exception as e:
    packet_free(p)
    vmp.except_s(str(e))
  return p

