/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 28/10/2024
 */

#include "vmp.h"
#include "pylib.h"
#include "net.h"

#ifndef VAMPIRIA_PY_NET_H

#define VAMPIRIA_PY_NET_H 1

//!Python wrapper of the c++ namespace vampiria::net in vmp_net.(see c++ doc)
/*!
    Function c++ in net/address.h:<BR>is_ipv4_raw(),ipv4_expand(),is_ipv6_raw(),is_ip_raw(),ip_to_buf(),ipv4_from_buf(),ipv6_from_buf(),
    is_macaddress_raw(),macaddress_to_buf(),macaddress_from_buf()
*/
/*!
    Const c++ in net/connection.h:<BR>CONN_NONE,CONN_UDP4,CONN_UDP6,CONN_UDPCONNECT,CONN_UDPPROXY
                 CONN_TCPSERVER,CONN_TCPCLIENT,CONN_TCPPROXY,CONN_TCPBIND,
                 CONN_TCPBINDPROXY   
                 
*/
/*!
    Const c++ in net/connection.h:<BR>conn_strtype()
*/
/*!
    Const c++ in net/connection/proxy.h:<BR>
    socks_cd_connect,socks_cd_bind,socks_cd_udpassociate
    socks4_result_granted,socks4_result_failed,socks4_result_reject,
    socks4_result_rejectuserid,socks5_result_ok,socks5_result_failure,
    socks5_result_notallowed,socks5_result_netunreachable,
    socks5_result_hostunreachable,socks5_result_refused,socks5_result_ttlexpired,
    socks5_result_badcmd,socks5_result_badatype,socks_internal_badauth,
    socks_internal_badaddr,socks_internal_accessdenied
*/
/*!
    Const c++ in net/connection/eventsocks.h.h:<BR>
    evtsocks_status_init,evtsocks_status_request,evtsocks_status_bind,
    evtsocks_status_established,evtsocks_status_close
*/
/*!
    Function c++ in net/connection/proxy.h:<BR>socks_msg_result()
*/
/*!
    Proxy Class in net/connection/proxy.h:<BR>no costructor<BR>
    Proxy member function list:<BR>
    type(),address(),user(),password()
*/
/*!
    ProxyChain Class in net/connection/proxy.h:<BR>Constructor ProxyChain(manager,logger)<BR>
    ProxyChain member function list:<BR>
    set_timeout(),get_timeout(),reset(),size(),push_socks4(),insert_socks4(),
    replace_socks4(),push_socks5(),insert_socks5(),replace_socks5(),
    push_socks5_userauth(),insert_socks5_userauth(),replace_socks5_userauth(),
    get(),cancel()
*/
/*!
    Const c++ in net/socket.h:<BR>UDP_MSIZE_DEFAULT
*/
/*!
    Function c++ in net/socket.h:<BR>
    socket_datagram(),socket_stream(),socket_connect_check(),
    socket_bind(),socket_listen(),socket_accept(),socket_addrlocal(),
    socket_addrpeer(),socket_close(),socket_timeout(),socket_recvFrom(),
    socket_recv(),socket_sendTo(),socket_send()
*/
/*!
    Function c++ in net/dns.h:<BR>tcp_resolve4(),tcp_resolve6(),tcp_resolveMX()
*/
void net_init(pylib::Module module);

//!Python wrapper of the c++ class vampiria::net::Address in vmp_net.Address(see c++ doc)
/*!
    Address class in net/address.h:<BR>Constructor Address() or Address(dnstype,dnsip) or Address(dnstype,dnsip,dnsport) or Address(dnstype,dnsip,dnsport,dnstout)<BR>
    Address member function list:<BR>reset(),set(),set_ip_raw(),copy(),host(),ip(),service(),is_ipv4(),is_ipv6(),onlyhost()
*/
void net_init_address(pylib::Module module);

//!Python wrapper of the c++ class vampiria::net::MacAddress in vmp_net.MacAddress(see c++ doc)
/*!
    MacAddress class in net/address.h:<BR>Constructor MacAddress()<BR>
    MacAddress member function list:<BR>reset(),set(),str_addr(),byte_addr()
*/
void net_init_macaddress(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::net in vmp_net.(see c++ doc)
/*!
    Function c++ in net/netdevice.h:<BR>iface_mac(),iface_ipv4(),iface_ipv4_netmask(),iface_ipv4_broadcast(),iface_ipv4_mtu()
*/
void net_init_netdevice(pylib::Module module);

//!Python wrapper of  of the c++ class vampiria::net::UdpUI in vmp_net.UdpUI(see c++ doc)
/*!
    Wrapper Cell->ui() in udpui(cell)<BR>
    @return user interface UdpUI for cell.(The cell must be built with the UdpUI user interface)
*/
/*!
    UdpUI Class in net/udp.h:<BR>Constructor UdpUI(manager)<BR>
    UdpUI member function list:<BR>
    set_event(),new_bind(),new_udp4(),new_udp6(),new_client(),sendTo(),
    send(),maxpsize(),localaddr(),peeraddr(),proxyinfo(),connection_type(),
    connection_strtype(),lastfrag()
*/
void net_init_udpui(pylib::Module module);

//!Python wrapper of  of the c++ class vampiria::net::TcpUI in vmp_net.TcpUI(see c++ doc)
/*!
    Wrapper Cell->ui() in tcpui(cell)<BR>
    @return user interface TcpUI for cell.(The cell must be built with the TcpUI user interface)
*/
/*!
    TcpUI Class in net/tcp.h:<BR>Constructor TcpUI(manager)<BR>
    TcpUI member function list:<BR>
    set_event_client(),set_event_server(),set_event_bind(),new_client(),
    new_server(),new_bind(),send(),localaddr(),peeraddr(),bindaddr(),bindservice(),
    proxyinfo(),connection_type()
*/
void net_init_tcpui(pylib::Module module);

//!Python wrapper of  of the c++ class vampiria::net::SocksUI in vmp_net.SocksUI(see c++ doc)
/*!
    Wrapper Cell->ui() in socksui(cell)<BR>
    @return user interface SocksUI for cell.(The cell must be built with the TcpUI user interface)
*/
/*!
    TcpUI Class in net/socks.h:<BR>Constructor SocksUI(manager)<BR>
    TcpUI member function list:<BR>
    set_tcp_event(),set_timeout(),set_auths(),set_connect_event(),set_bind_event(),
    set_udpassociate_event(),new_server(),reply_error(),reply_connect(),
    reply_bind_listen(),reply_bind_connect(),reply_udpassociate(),send(),sendTo(),
    localaddr(),peeraddr(),connection_type(),connection_strtype(),cstatus(),
    userid(),permits(),socks_command(),socks_command_str(),socks_address(),
    socks_udpbind()
*/
void net_init_socksui(pylib::Module module);

#endif

