/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 05/11/2024
 */

#include "net_.h"

struct ProxyChain_Constructor:public pylib::Constructor<net::ProxyChain>
{
    net::ProxyChain *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             return new net::ProxyChain(manager);
         }
         else if(args.size() == 2)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             vmp::utils::Logger *logger=0;
             if(!args.is_none(1))
                 logger=args.get<vmp::utils::Logger *>(1);
             return new net::ProxyChain(manager,logger);
         }
         return 0;
    }
};

struct stub_socket_recvFrom:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            net::Socket sock=args.get<net::Socket>(0);
            vmp::Buf *buf=args.get<vmp::Buf *>(1);
            net::Address *peer=args.get<net::Address *>(2);
            return pylib::Converter<vmp_int>(net::socket_recvFrom(sock,buf,peer));
        }
        else if(args.size() == 4)
        {
            net::Socket sock=args.get<net::Socket>(0);
            vmp::Buf *buf=args.get<vmp::Buf *>(1);
            net::Address *peer=args.get<net::Address *>(2);
            vmp_size udpmsize=args.get<vmp_size>(3);
            return pylib::Converter<vmp_int>(net::socket_recvFrom(sock,buf,peer,udpmsize));   
        }
        return 0;
    }
};

struct stub_socket_sendTo:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 3)
        {
            net::Socket sock=args.get<net::Socket>(0);
            vmp::Buf *buf=args.get<vmp::Buf *>(1);
            net::Address *peer=args.get<net::Address *>(2);
            return pylib::Converter<vmp_int>(net::socket_sendTo(sock,buf,peer));
        }
        else if(args.size() == 4)
        {
            net::Socket sock=args.get<net::Socket>(0);
            vmp::Buf *buf=args.get<vmp::Buf *>(1);
            net::Address *peer=args.get<net::Address *>(2);
            vmp_size udpmsize=args.get<vmp_size>(3);
            return pylib::Converter<vmp_int>(net::socket_sendTo(sock,buf,peer,udpmsize));   
        }
        return 0;
         
   }
};

void net_init(pylib::Module module)
{
    //net/address.h
    module.def_("is_ipv4_raw",net::is_ipv4_raw);
    module.def_("ipv4_expand",net::ipv4_expand);
    module.def_("is_ipv6_raw",net::is_ipv6_raw);
    module.def_("is_ip_raw",net::is_ip_raw);
    module.def_("ip_to_buf",net::ip_to_buf);
    module.def_("ipv4_from_buf",net::ipv4_from_buf);
    module.def_("ipv6_from_buf",net::ipv6_from_buf);
    module.def_("is_macaddress_raw",net::is_macaddress_raw);
    module.def_("macaddress_to_buf",net::macaddress_to_buf);
    module.def_("macaddress_from_buf",net::macaddress_from_buf);
    
    //net/connection.h
    module.add_const<vmp_int>("CONN_NONE",net::CONN_NONE);
    module.add_const<vmp_int>("CONN_UDP4",net::CONN_UDP4);
    module.add_const<vmp_int>("CONN_UDP6",net::CONN_UDP6);
    module.add_const<vmp_int>("CONN_UDPCONNECT",net::CONN_UDPCONNECT);
    module.add_const<vmp_int>("CONN_UDPPROXY",net::CONN_UDPPROXY);
    module.add_const<vmp_int>("CONN_TCPLISTEN",net::CONN_TCPLISTEN);
    module.add_const<vmp_int>("CONN_TCPSERVER",net::CONN_TCPSERVER);
    module.add_const<vmp_int>("CONN_TCPCLIENT",net::CONN_TCPCLIENT);
    module.add_const<vmp_int>("CONN_TCPPROXY",net::CONN_TCPPROXY);
    module.add_const<vmp_int>("CONN_TCPBIND",net::CONN_TCPBIND);
    module.add_const<vmp_int>("CONN_TCPBINDPROXY",net::CONN_TCPBINDPROXY);
    module.def_("conn_strtype",net::conn_strtype);
    
    //net/connection/proxy.h
    module.add_const<vmp_byte>("socks_cd_connect",net::socks_cd_connect);
    module.add_const<vmp_byte>("socks_cd_bind",net::socks_cd_bind);
    module.add_const<vmp_byte>("socks_cd_udpassociate",net::socks_cd_udpassociate);
    module.add_const<vmp_byte>("socks4_result_granted",net::socks4_result_granted);
    module.add_const<vmp_byte>("socks4_result_failed",net::socks4_result_failed);
    module.add_const<vmp_byte>("socks4_result_reject",net::socks4_result_reject);
    module.add_const<vmp_byte>("socks4_result_rejectuserid",net::socks4_result_rejectuserid);
    module.add_const<vmp_byte>("socks5_result_ok",net::socks5_result_ok);
    module.add_const<vmp_byte>("socks5_result_failure",net::socks5_result_failure);
    module.add_const<vmp_byte>("socks5_result_notallowed",net::socks5_result_notallowed);
    module.add_const<vmp_byte>("socks5_result_netunreachable",net::socks5_result_netunreachable);
    module.add_const<vmp_byte>("socks5_result_hostunreachable",net::socks5_result_hostunreachable);
    module.add_const<vmp_byte>("socks5_result_refused",net::socks5_result_refused);
    module.add_const<vmp_byte>("socks5_result_ttlexpired",net::socks5_result_ttlexpired);
    module.add_const<vmp_byte>("socks5_result_badcmd",net::socks5_result_badcmd);
    module.add_const<vmp_byte>("socks5_result_badatype",net::socks5_result_badatype);
    module.add_const<vmp_byte>("socks_internal_badauth",net::socks_internal_badauth);
    module.add_const<vmp_byte>("socks_internal_badaddr",net::socks_internal_badaddr);
    module.add_const<vmp_byte>("socks_internal_accessdenied",net::socks_internal_accessdenied);
    module.def_("socks_msg_result",net::socks_msg_result);
    
    module.add_const<vmp_byte>("evtsocks_status_init",net::evtsocks_status_init);
    module.add_const<vmp_byte>("evtsocks_status_request",net::evtsocks_status_request);
    module.add_const<vmp_byte>("evtsocks_status_bind",net::evtsocks_status_bind);
    module.add_const<vmp_byte>("evtsocks_status_established",net::evtsocks_status_established);
    module.add_const<vmp_byte>("evtsocks_status_close",net::evtsocks_status_close);
    
    pylib::Class<net::Proxy> proxy=module.class_no_constructor<net::Proxy>("Proxy");
    proxy.def_("type",&net::Proxy::type);
    proxy.def_("address",&net::Proxy::address,false);
    proxy.def_("user",&net::Proxy::user);
    proxy.def_("password",&net::Proxy::password);
    
    pylib::Class<net::ProxyChain> proxychain=module.class_with_constructor<net::ProxyChain>("ProxyChain",ProxyChain_Constructor());
    proxychain.def_("set_timeout",&net::ProxyChain::set_timeout);
    proxychain.def_("get_timeout",&net::ProxyChain::get_timeout);
    proxychain.def_("reset",&net::ProxyChain::reset);
    proxychain.def_("size",&net::ProxyChain::size);
    proxychain.def_("push_socks4",&net::ProxyChain::push_socks4);
    proxychain.def_("insert_socks4",&net::ProxyChain::insert_socks4);
    proxychain.def_("replace_socks4",&net::ProxyChain::replace_socks4);
    proxychain.def_("push_socks5",&net::ProxyChain::push_socks5);
    proxychain.def_("insert_socks5",&net::ProxyChain::insert_socks5);
    proxychain.def_("replace_socks5",&net::ProxyChain::replace_socks5);
    proxychain.def_("push_socks5_userauth",&net::ProxyChain::push_socks5_userauth);
    proxychain.def_("insert_socks5_userauth",&net::ProxyChain::insert_socks5_userauth);
    proxychain.def_("replace_socks5_userauth",&net::ProxyChain::replace_socks5_userauth);
    proxychain.def_("get",&net::ProxyChain::get,false);
    proxychain.def_("cancel",&net::ProxyChain::cancel);
    
    //net/socket.h
    module.add_const<vmp_size>("UDP_MSIZE_DEFAULT",net::UDP_MSIZE_DEFAULT);
    module.def_("socket_datagram",net::socket_datagram);
    module.def_("socket_stream",net::socket_stream);
    module.def_("socket_connect",net::socket_connect);
    module.def_("socket_connect_check",net::socket_connect_check);
    module.def_("socket_bind",net::socket_bind);
    module.def_("socket_listen",net::socket_listen);
    module.def_("socket_accept",net::socket_accept);
    module.def_("socket_addrlocal",net::socket_addrlocal);
    module.def_("socket_addrpeer",net::socket_addrpeer);
    module.def_("socket_close",net::socket_close);
    module.def_("socket_timeout",net::socket_timeout);
    module.def_with_stub("socket_recvFrom",stub_socket_recvFrom());
    module.def_("socket_recv",net::socket_recv);
    module.def_with_stub("socket_sendTo",stub_socket_sendTo());
    module.def_("socket_send",net::socket_send);
    
    //net/dns.h
    module.def_("tcp_resolve4",net::tcp_resolve4);
    module.def_("tcp_resolve6",net::tcp_resolve6);
    module.def_("tcp_resolveMX",net::tcp_resolveMX);
}

VAMPIRIA_PYLIB_INIT(vmp_net_);

void vampiria_pylib_init_module(pylib::Module init_module)
{
    net_init(init_module);
    net_init_address(init_module);
    net_init_netdevice(init_module);
    net_init_macaddress(init_module);
    net_init_udpui(init_module);
    net_init_tcpui(init_module);
    net_init_socksui(init_module);
}

