/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/01/2024
 */

#include "net_.h"

struct Address_Constructor:public pylib::Constructor<net::Address>
{
    net::Address *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str dnstype,dnsip,dnsport;
         vmp::time::Time dnstout;
         if(args.size() == 0)
             return new net::Address();
         else if(args.size() == 2)
         {
             dnstype=args.get<vmp::str>(0);  
             dnsip=args.get<vmp::str>(1);
             return new net::Address(dnstype,dnsip);
         }
         else if(args.size() == 3)
         {
             dnstype=args.get<vmp::str>(0);
             dnsip=args.get<vmp::str>(1);
             dnsport=args.get<vmp::str>(2);
             return new net::Address(dnstype,dnsip,dnsport);
         }
         else if(args.size() == 4)
         {
             dnstype=args.get<vmp::str>(0);
             dnsip=args.get<vmp::str>(1);
             dnsport=args.get<vmp::str>(2);
             dnstout=args.get<vmp::time::Time>(3);
             return new net::Address(dnstype,dnsip,dnsport,dnstout);
         }
         return 0;
    }
};

struct stub_address_set:public pylib::Member_def<net::Address>
{
    pylib::Objref *def(net::Address *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str host=args.get<vmp::str>(0);
            instance->set(host);
        }
        else if (args.size() == 2)
        {
            vmp::str host=args.get<vmp::str>(0);
            vmp::str service=args.get<vmp::str>(1);
            instance->set(host,service);
        }
        else if(args.size() == 3)
        {
            vmp::str host=args.get<vmp::str>(0);
            vmp::str service=args.get<vmp::str>(1);
            vmp_bool onlyhost=args.get<vmp_bool>(2);
            instance->set(host,service,onlyhost);
        }
        else    
            return 0;
        return pylib::retnone();
    }
};

struct stub_address_set_ip_raw:public pylib::Member_def<net::Address>
{
    pylib::Objref *def(net::Address *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str host=args.get<vmp::str>(0);
            instance->set_ip_raw(host);
        }
        else if (args.size() == 2)
        {
            vmp::str host=args.get<vmp::str>(0);
            vmp::str service=args.get<vmp::str>(1);
            instance->set_ip_raw(host,service);
        }
        else    
            return 0;
        return pylib::retnone();
    }
};

void net_init_address(pylib::Module module)
{
    //net/address.h
    pylib::Class<net::Address> address=module.class_with_constructor<net::Address>("Address",Address_Constructor());
    address.def_("reset",&net::Address::reset);
    address.def_with_stub("set",stub_address_set());
    address.def_with_stub("set_ip_raw",stub_address_set_ip_raw());
    address.def_("copy",&net::Address::copy);
    address.def_("host",&net::Address::host);
    address.def_("ip",&net::Address::ip);
    address.def_("service",&net::Address::service);
    address.def_("is_ipv4",&net::Address::is_ipv4);
    address.def_("is_ipv6",&net::Address::is_ipv6);
    address.def_("is_onlyhost",&net::Address::is_onlyhost);
}

