/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 20/03/2025
 */

#include "json_.h"

struct stub_japi_type_list:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 0)
             return pylib::Converter<vmp::str>(json::japi_type_list());
         else if(args.size() == 1)
         {
             vmp::str jtype=args.get<vmp::str>(0);
             return pylib::Converter<vmp::str>(json::japi_type_list(jtype));
         }
         return 0;
    }
};

struct stub_japi_type_table:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 0)
             return pylib::Converter<vmp::str>(json::japi_type_table());
         else if(args.size() == 1)
         {
             vmp::str jtype=args.get<vmp::str>(0);
             return pylib::Converter<vmp::str>(json::japi_type_table(jtype));
         }
         return 0;
    }
};

struct stub_japi_list:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             json::JsonObj *obj=args.get<json::JsonObj *>(0);
             json::japi_list(obj);
             return pylib::retnone();
         }
         else if(args.size() == 2)
         {
             json::JsonObj *obj=args.get<json::JsonObj *>(0);
             vmp::str datatype;
             json::JList *list=0;
             try
             {
                 datatype=args.get<vmp::str>(1);
             }
             catch(vmp::exception &x)
             {
                 list=args.get<json::JList *>(1);
             }
             if(list == 0)
                 json::japi_list(obj,datatype);
             else
                 json::japi_list(obj,list);
             return pylib::retnone();    
         }
         return 0;
    }
};

struct stub_japi_table:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             json::JsonObj *obj=args.get<json::JsonObj *>(0);
             json::japi_table(obj);
             return pylib::retnone();
         }
         else if(args.size() == 2)
         {
             json::JsonObj *obj=args.get<json::JsonObj *>(0);
             vmp::str datatype;
             json::JTable *table=0;
             try
             {
                 datatype=args.get<vmp::str>(1);
             }
             catch(vmp::exception &x)
             {
                 table=args.get<json::JTable *>(1);
             }
             if(table == 0)
                 json::japi_table(obj,datatype);
             else
                 json::japi_table(obj,table);
             return pylib::retnone();    
         }
         return 0;    
     }
};

struct stub_japi_oper:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str id=args.get<vmp::str>(1);
            json::JsonObj *data=args.get<json::JsonObj *>(2);
            json::japi_oper(obj,id,data);
            return pylib::retnone();
        }
        else if(args.size() == 4)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str id=args.get<vmp::str>(1);
            json::JsonObj *data=args.get<json::JsonObj *>(2);
            vmp::Buf *bin=args.get<vmp::Buf *>(3);
            json::japi_oper(obj,id,data,bin);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_japi_oper_data:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str id=args.get<vmp::str>(1);
            json::JsonObj *data=args.get<json::JsonObj *>(2);
            json::japi_oper_data(obj,id,data);
            return pylib::retnone();
        }
        else if(args.size() == 4)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str id=args.get<vmp::str>(1);
            json::JsonObj *data=args.get<json::JsonObj *>(2);
            vmp::Buf *bin=args.get<vmp::Buf *>(3);
            json::japi_oper_data(obj,id,data,bin);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_japi_oper_push:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str id=args.get<vmp::str>(1);
            json::JsonObj *data=args.get<json::JsonObj *>(2);
            json::japi_oper_push(obj,id,data);
            return pylib::retnone();
        }
        else if(args.size() == 4)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str id=args.get<vmp::str>(1);
            json::JsonObj *data=args.get<json::JsonObj *>(2);
            vmp::Buf *bin=args.get<vmp::Buf *>(3);
            json::japi_oper_push(obj,id,data,bin);
            return pylib::retnone();
        }
        return 0;
    }
};


struct stub_japi_login:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str user=args.get<vmp::str>(1);
            vmp::str password=args.get<vmp::str>(2);
            json::japi_login(obj,user,password);
            return pylib::retnone();
        }
        else if(args.size() == 4)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str user=args.get<vmp::str>(1);
            vmp::str password=args.get<vmp::str>(2);
            vmp_bool md5_password=args.get<vmp_bool>(3);
            json::japi_login(obj,user,password,md5_password);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_japi_login_b64_e:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str user=args.get<vmp::str>(0);
            vmp::str password=args.get<vmp::str>(1);
            return pylib::Converter<vmp::str>(json::japi_login_b64_e(user,password));
        }
        else if(args.size() == 3)
        {
            vmp::str user=args.get<vmp::str>(0);
            vmp::str password=args.get<vmp::str>(1);
            vmp_bool md5_password=args.get<vmp_bool>(2);
            return pylib::Converter<vmp::str>(json::japi_login_b64_e(user,password,md5_password));
        }
        return 0;
    }
};

struct stub_japi_passwd:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str oldpassword=args.get<vmp::str>(1);
            vmp::str password=args.get<vmp::str>(2);
            json::japi_passwd(obj,oldpassword,password);
            return pylib::retnone();
        }
        else if(args.size() == 4)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str oldpassword=args.get<vmp::str>(1);
            vmp::str password=args.get<vmp::str>(2);
            vmp_bool md5_password=args.get<vmp_bool>(3);
            json::japi_passwd(obj,oldpassword,password,md5_password);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_japi_useradd:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 5)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str user=args.get<vmp::str>(1);
            vmp::str password=args.get<vmp::str>(2);
            vmp_uint permits=args.get<vmp_uint>(3);
            vmp_bool only_localhost=args.get<vmp_bool>(4);
            json::japi_useradd(obj,user,password,permits,only_localhost);
            return pylib::retnone();
        }
        else if(args.size() == 6)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str user=args.get<vmp::str>(1);
            vmp::str password=args.get<vmp::str>(2);
            vmp_uint permits=args.get<vmp_uint>(3);
            vmp_bool only_localhost=args.get<vmp_bool>(4);
            vmp_bool md5_password=args.get<vmp_bool>(5);
            json::japi_useradd(obj,user,password,permits,only_localhost,md5_password);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_japi_userpasswd:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str user=args.get<vmp::str>(1);
            vmp::str password=args.get<vmp::str>(2);
            json::japi_userpasswd(obj,user,password);
            return pylib::retnone();
        }
        else if(args.size() == 4)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str user=args.get<vmp::str>(1);
            vmp::str password=args.get<vmp::str>(2);
            vmp_bool md5_password=args.get<vmp_bool>(3);
            json::japi_userpasswd(obj,user,password,md5_password);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_japi_connectinfo:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 7)
        {
            json::JsonObj *obj=args.get<json::JsonObj *>(0);
            vmp::str id=args.get<vmp::str>(1);
            vmp::str type=args.get<vmp::str>(2);
            vmp::str aux=args.get<vmp::str>(3);
            vmp_uint permits=args.get<vmp_uint>(4);
            vmp::str address=args.get<vmp::str>(5);
            vmp_uint port=args.get<vmp_uint>(6);
            json::japi_connectinfo(obj,id,type,aux,permits,address,port);
            return pylib::retnone();
        }
       return 0;
    }
};

void json_japi(pylib::Module module)
{
    module.def_("japi",json::japi);
    module.def_with_stub("japi_type_list",stub_japi_type_list());
    module.def_with_stub("japi_type_table",stub_japi_type_table());
    module.def_("japi_void",json::japi_void);
    module.def_with_stub("japi_list",stub_japi_list());
    module.def_with_stub("japi_table",stub_japi_table());
    module.def_with_stub("japi_oper",stub_japi_oper());
    module.def_("japi_oper_kill",json::japi_oper_kill);
    module.def_with_stub("japi_oper_data",stub_japi_oper_data());
    module.def_with_stub("japi_oper_push",stub_japi_oper_push());
    module.def_("japi_oper_close",json::japi_oper_close);
    module.def_("japi_status",json::japi_status);
    module.def_("japi_status_update",json::japi_status_update);
    module.def_("japi_status_cancel",json::japi_status_cancel);
    module.def_with_stub("japi_login",stub_japi_login());
    module.def_with_stub("japi_login_b64_e",stub_japi_login_b64_e());
    module.def_("japi_login_b64_d",json::japi_login_b64_d);
    module.def_with_stub("japi_passwd",stub_japi_passwd());
    module.def_("japi_userlist",json::japi_userlist);
    module.def_("japi_userinfo",json::japi_userinfo);
    module.def_with_stub("japi_useradd",stub_japi_useradd());
    module.def_("japi_usermod",json::japi_usermod);
    module.def_with_stub("japi_userpasswd",stub_japi_userpasswd());
    module.def_("japi_userdel",json::japi_userdel);
    module.def_("japi_peerlist",json::japi_peerlist);
    module.def_("japi_peerinfo",json::japi_peerinfo);
    module.def_("japi_peeradd",json::japi_peeradd);
    module.def_("japi_peermod",json::japi_peermod);
    module.def_("japi_peerdel",json::japi_peerdel);
    module.def_("japi_connectlist",json::japi_connectlist);
    module.def_with_stub("japi_connectinfo",stub_japi_connectinfo());
    module.def_("japi_connectclose",json::japi_connectclose);
}

