/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 02/01/2024
*/

#include "jrp_.h"

struct Misc_Status_stub_Constructor:public pylib::Constructor<jrp::misc::Status>
{
    jrp::misc::Status *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str dirpath=args.get<vmp::str>(0);
            return new jrp::misc::Status(dirpath);
        }
        else if(args.size() == 2)
        {
            vmp::str dirpath=args.get<vmp::str>(0);
            vmp_bool cache=args.get<vmp_bool>(1);
            return new jrp::misc::Status(dirpath,cache);  
        }
        return 0;
    }
};

struct stub_misc_status_keys:public pylib::Member_def<jrp::misc::Status>
{
    pylib::Objref *def(jrp::misc::Status *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return pylib::Converter<vmp::vector<vmp::str >>(instance->keys());
        else if(args.size() == 1)
        {
            vmp::str jtype=args.get<vmp::str>(0);
            return pylib::Converter<vmp::vector<vmp::str > >(instance->keys(jtype));
        }
        return 0;
    }
};

struct stub_misc_status_request_close:public pylib::Member_def<jrp::misc::Status>
{
    pylib::Objref *def(jrp::misc::Status *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str jreqkey=args.get<vmp::str>(0);
            vmp_int status=args.get<vmp_int>(1);
            instance->request_close(jreqkey,status);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp::str jreqkey=args.get<vmp::str>(0);
            vmp_int status=args.get<vmp_int>(1);
            vmp::str msg=args.get<vmp::str>(2);
            instance->request_close(jreqkey,status,msg);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_misc_status_register_common:public pylib::Member_def<jrp::misc::Status>
{
    pylib::Objref *def(jrp::misc::Status *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            instance->register_common(common);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            jrp::JrpCommon *common=(jrp::JrpCommon *)args.get<PyJrpCommon *>(0);
            vmp::str permits=args.get<vmp::str>(1);
            instance->register_common(common,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

void jrp_misc_status(pylib::Module module)
{
    pylib::Class<jrp::misc::Status> status=module.class_with_constructor<jrp::misc::Status>("Status",Misc_Status_stub_Constructor());
    status.def_("root",&jrp::misc::Status::root,false);
    status.def_("set_limit",&jrp::misc::Status::set_limit);
    status.def_("backup",&jrp::misc::Status::backup);
    status.def_with_stub("keys",stub_misc_status_keys());
    status.def_("update",&jrp::misc::Status::update);
    status.def_("update_from_japi",&jrp::misc::Status::update_from_japi);
    status.def_("cancel",&jrp::misc::Status::cancel);
    status.def_("cancel_from_japi",&jrp::misc::Status::cancel_from_japi);
    status.def_("search",&jrp::misc::Status::search);
    status.def_("request_open",&jrp::misc::Status::request_open);
    status.def_with_stub("request_close",stub_misc_status_request_close());
    status.def_with_stub("register_common",stub_misc_status_register_common());
    status.def_("management",&jrp::misc::Status::management);
    status.def_("management_kill",&jrp::misc::Status::management_kill);
}

