/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 18/08/2024
*/

#include "db_.h"

struct Sqlite_stub_Constructor:public pylib::Constructor<db::Sqlite>
{
    db::Sqlite *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str db=args.get<vmp::str>(0);
            return new db::Sqlite(db); 
        }
        return 0;
    }
};

struct stub_sqlite_query:public pylib::Member_def<db::Sqlite>
{
    pylib::Objref *def(db::Sqlite *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str sql=args.get<vmp::str>(0);
            instance->query(sql);
            return pylib::retnone();    
        }
        else if(args.size() == 2)
        {
            vmp::str sql=args.get<vmp::str>(0);
            if(args.is_none(1))
                instance->query(sql);
            else
            {
                db::Result *result=args.get<db::Result *>(1);
                instance->query(sql,result);
            }
            return pylib::retnone();
        }
        return 0;
    }
};

void app_db_init(pylib::Module module)
{
    pylib::Class<db::Result> result=module.class_<db::Result>("Result");
    result.def_("reset",&db::Result::reset);
    result.def_("size_fields",&db::Result::size_fields);
    result.def_("get_field",&db::Result::get_field);
    result.def_("size",&db::Result::size);
    result.def_("get_row",&db::Result::get_row);
    result.def_("get_column",&db::Result::get_column);
    result.def_("get_column_name",&db::Result::get_column_name);
    result.def_("get_value",&db::Result::get_value);
    result.def_("get_value_name",&db::Result::get_value_name);
    
    pylib::Class<db::Sqlite> sqlite=module.class_with_constructor<db::Sqlite>("Sqlite",Sqlite_stub_Constructor());
    sqlite.def_("filedb",&db::Sqlite::filedb);
    sqlite.def_("show_tables",&db::Sqlite::show_tables);
    sqlite.def_("exist_table",&db::Sqlite::exist_table);
    sqlite.def_with_stub("query",stub_sqlite_query());
    sqlite.def_("verify",&db::Sqlite::verify);
}

VAMPIRIA_PYLIB_INIT(vmp_db_);
 
void vampiria_pylib_init_module(pylib::Module init_module)
{
    app_db_init(init_module);
}

