/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 20/03/2025
 */
 
#include "crypto_.h"

struct SslBio_stub_Constructor:public pylib::Constructor<crypto::SslBio>
{
    crypto::SslBio *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return new crypto::SslBio();
        else if(args.size() == 1)
        {
            crypto::Ctx *ctx=args.get<crypto::Ctx *>(0);
            return new crypto::SslBio(ctx);
        }
        return 0;
    }
};

void crypto_sslbio(pylib::Module module)
{
    pylib::Class<crypto::SslBio> sslbio=module.class_with_constructor<crypto::SslBio>("SslBio",SslBio_stub_Constructor());
    sslbio.def_("reset",&crypto::SslBio::reset);
    sslbio.def_("set",&crypto::SslBio::set);
    sslbio.def_("get_errno",&crypto::SslBio::get_errno);
    sslbio.def_("get_error",&crypto::SslBio::get_error);
    sslbio.def_("ctx",&crypto::SslBio::ctx,false);
    sslbio.def_("get_local_x509",&crypto::SslBio::get_local_x509);
    sslbio.def_("get_peer_x509",&crypto::SslBio::get_peer_x509);
    sslbio.def_("connect",&crypto::SslBio::connect);
    sslbio.def_("accept",&crypto::SslBio::accept);
    sslbio.def_("is_client",&crypto::SslBio::is_client);
    sslbio.def_("is_server",&crypto::SslBio::is_server);
    sslbio.def_("recv",&crypto::SslBio::recv);
    sslbio.def_("send",&crypto::SslBio::send);
    sslbio.def_("key_update",&crypto::SslBio::key_update);
    sslbio.def_("shutdown",&crypto::SslBio::shutdown);
    sslbio.def_("close",&crypto::SslBio::close);
}

