/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/01/2025
 */

#include "vmp.h"
#include "pylib.h"

#ifndef VAMPIRIA_PY_VMP_H

#define VAMPIRIA_PY_VMP_H 1

//!Python wrapper of the c++ namespace vampiria::vmp in vmp.(see c++ doc)
/*!
    Const c++ in vmp/basetypes.h":<BR>
    INTMIN,INTMAX,INT16MIN,INT16MAX,UINTMIN,UINTMAX,UINT16MIN,
    UINT16MAX,CHARMIN,CHARMAX,UCHAR_MIN,UCHAR_MAX,RANDMAX,INT64MIN,INT64MAX,
    UINT64MIN,UINT64MAX
*/
/*!
    Function c++ in vmp/error.h:<BR> except_s(),get_errno(),value_errno()
*/
/*!
    Function c++ in vmp/io.h:<BR>
    init(),is_debug_mode(),id(),io_forced_unlock(),io_recovery_lock(),
    debug(),info(),warning(),error(),error_raw(),output(),output_raw(),
    output_file(),output_file_lines(),input(),input_file(),input_file_s(),
    exit_ok(),exit_failure(),copy_file(),move_file()
*/
/*!
    Function c++ in vmp/lib/types.h:<BR>
    srand_wrap(),rand_wrap()
*/
/*!
    Function c++ in vmp/lib/fd.h:<BR>
    dup2_wrap(),fd_noblock(),fd_block(),fd_fsync()
*/
/*!
    Function c++ in vmp/lib/process.h:<BR>
    system_wrap(),getpid_wrap(),getuid_wrap(),geteuid_wrap(),getgid_wrap(),getegid_wrap(),
    getuid_user(),getgid_user(),setuid_wrap(),setgid_wrap(),setuid_user(),setgid_user()
    pause_wrap(),kill_wrap()
*/
/*!
    Function c++ in vmp/signal.h:<BR>signum(),sigstr(),sigcmp(),signal_wrap()
*/
/*!
    Dev_t_wrap class in vmp/lib/dev.h<BR>Constructor Dev_t_wrap()<BR>
    Dev_t_wrap member function list:<BR>
*/
void vmp_init(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::vmp::env in vmp.env.(see c++ doc)
/*!
    Function c++ in vmp/env.h:<BR>
    author(),email(),webpage(),license(),version(),vampiria_path(),vampiria_frm(),
    vampiria_web_root(),vampiria_web(),vampiria_bin(),vampiria_lib(),
    vampiria_cache(),vampiria_home(),software_root(),software_path(),
    software_isinstalled(),modules_root(),module_path(),module_main_path(),
    module_web_path(),module_manifest(),module_isinstalled(),frm_dtd(),
    python_exe(),python_env(),python_moduleimp(),python_main(),
    python_software_main(),python_files_check(),xml_hdr(),format_path()
*/
void vmp_init_env(pylib::Module module);

//!Python wrapper of the c++ class vampiria::vmp::Buf in vmp.Buf(see c++ doc)
/*!
    Const c++ in vmp/buf.h":<BR>BUFSIZEMAX
*/
/*!
    Buf class in vmp/buf.h:<BR>Constructor Buf()<BR>
    Buf member function list:<BR>
    newsize(),size(),size_reading(),index(),get_index(),eob(),reset(),
    write_byte(),read_byte(),write_vector(),read_vector(),write_size(),read_size(),
    write_size64(),read_size64(),write_str(),read_str(),write_xstr(),read_xstr(),
    read_xstr_hm(),cat(),cathead(),write_buf(),read_buf(),cut(),
    write_file(),read_filecreate(),read_filewrite(),read_fileappend()
*/
void vmp_init_buf(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::fs in vmp.fs.(see c++ doc)
/*!
    Function c++ in vmp/lib/fs.h:<BR>
    unlink_wrap(),format_dirpath(),union_path(),chmod_wrap(),mkdir_wrap(),
    rmdir_wrap(),chdir_wrap(),isdir(),isrdir(),iswdir(),isxdir(),
    getcwd_wrap(),listendir(),isfile(),isrfile(),iswfile(),isxfile(),file_ext()
*/
/*!
    Mode_t_wrap class in vmp/lib/fs.h<BR>no constructor<BR>
    Mode_t_wrap member function list:<BR>
    isreg(),isdir(),ischr(),isblk(),isfifo(),islnk(),issock()
*/
/*!
    FileStat class in vmp/lib/fs.h<BR>constructor Filestat() or Filestat(filepath)<BR>
    Filestat member function list:<BR>
    reset(),set(),filepath(),dev(),ino(),mode(),nlink(),uid(),gid(),rdev(),
    size(),blksize(),blocks(),atime(),mtime(),ctime()
*/
void vmp_init_fs(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::thread in vmp.thread.(see c++ doc)
/*!
    Mutex class in vmp/thread.h:<BR>Constructor Mutex()<BR>
    Thread member function list:<BR>
    lock(),unlock(),forced_unlock(),recovery_lock()
*/
/*!
    Blocking class in vmp/thread.h:<BR>Constructor Blocking()<BR>
    Blocking member function list:<BR>
    pause(),unblock()
*/
void vmp_init_thread(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::time in vmp.time.(see c++ doc)
/*!
    Function c++ in vmp/time.h:<BR>vsleep(),time_wrap(),ctime_wrap(),gmtime_wrap()
*/
/*!
    Localtime class in vmp/time.h:<BR>Constructor Localtime(time=0)or Localtime(year,month,day,hour,min,sec)<BR>
    Localtime member function list:<BR>
    set(),get_year_days(),set_from_year_day(),next_cronizer(),
    time(),sec(),min(),hour(),mday(),wday(),wday_n(),month(),
    month_n(),year(),ctime(),gmtime(),year_day(),summertime()
*/
/*!
    Timer class in vmp/time.h:<BR>Constructor Timer()<BR>
    Timer member function list:<BR>
    init(),now()
*/
void vmp_init_time(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::unicode in vmp.unicode.(see c++ doc)
/*!
    Function c++ in vmp/unicode.h:<BR>
    str_tolower(),str_toupper(),str_split(),str_join(),byte_nbit(),
    str_istype(),str_todigit(),str_todigit_range(),str_todigit64(),
    str_todigit64_range()str_toreal(),str_toreal_range(),xstr_tobytes(),
    bytes_toxstr(),bytes_toxstr_hm(),str_toxstr(),xstr_tostr(),str_sub(),
    str_findsub(),str_replace(),str_casecmp(),str_trim(),str_isword(),
    str_format(),str_format_maxline(),str_format_end(),str_extract_char(),
    str_remove_duplex(),str_regex(),str_regex_matching(),str_invector(),
    shlex_split(),shlex_join(),str_toindex_list(),b64_encode(),b64_decode(),
    utf8_check()
*/
/*!
    Strtok class in vmp/unicode.h:<BR>Constructor Strtok() or Strtok(content)<BR>
    Strtok member funcyion list:<BR>
    reset(),set(),next(),get_char(),jump_chars()
*/
void vmp_init_unicode(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::utils in vmp.utils.(see c++ doc)
/*!
    Const c++ logger loglevel in vmp/utils.h":<BR>
    LOG_NO,LOG_DEBUG,LOG_INFO,LOG_WARN,LOG_ERR<BR>
    Logger class in vmp/utils.h:<BR>Constructor Logger<BR>
    Logger member function list:<BR>
    reset(),logname(),loglevel(),set(),write(),rotate()
*/
/*!
    Function c++ in vmp/utils.h:<BR>
    syslog_build(),syslog()
*/
void vmp_init_utils(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::PairList<vmp::str,vmp::str> in vmp.PairListStr.(see c++ doc)
/*!
    Pairlist class in vmp/pairlist.h:<BR>Constructor PairListStr()<BR>
    PairList member function list:<BR>
    clear(),size(),insert(),update(),push(),cancel(),all_key(),all_data(),
    position(),search(),get()
*/
void vmp_init_pairlist(pylib::Module module);

#endif

