/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 08/01/2025
 */

#include "vmp_.h"

void vmp_init_utils(pylib::Module module)
{
     pylib::Module utils=module.add_submodule("utils");

     // vmp/unicode.h
     utils.add_const<vmp_int>("LOG_NO",vmp::utils::LOG_NO);
     utils.add_const<vmp_int>("LOG_DEBUG",vmp::utils::LOG_DEBUG);
     utils.add_const<vmp_int>("LOG_INFO",vmp::utils::LOG_INFO);
     utils.add_const<vmp_int>("LOG_WARN",vmp::utils::LOG_WARN);
     utils.add_const<vmp_int>("LOG_ERR",vmp::utils::LOG_ERR);

     pylib::Class<vmp::utils::Logger> logger=utils.class_<vmp::utils::Logger>("Logger");
     logger.def_("reset",&vmp::utils::Logger::reset);
     logger.def_("logname",&vmp::utils::Logger::logname);
     logger.def_("loglevel",&vmp::utils::Logger::loglevel);
     logger.def_("set",&vmp::utils::Logger::set);
     logger.def_("write",&vmp::utils::Logger::write_s);
     logger.def_("rotate",&vmp::utils::Logger::rotate);
     
     utils.def_("syslog_build",vmp::utils::syslog_build);
     utils.def_("syslog",vmp::utils::syslog_s);
}

