/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 02/01/2025
 */

#include "vmp_.h"

struct stub_union_path:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         vmp::str arg1="";
         if(args.size() == 1)
         {
             arg0=args.get<vmp::str>(0);     
         }
         else if(args.size() == 2)
         {
             arg0=args.get<vmp::str>(0);
             arg1=args.get<vmp::str>(1);
         }
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::fs::union_path(arg0,arg1));
   }
};

struct FileStat_Constructor:public pylib::Constructor<vmp::fs::FileStat>
{
    vmp::fs::FileStat *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return new vmp::fs::FileStat();
        else if(args.size() == 1)
            return new vmp::fs::FileStat(args.get<vmp::str>(0)); 
        return 0;
    }
};

struct stub_FileStat_dev:public pylib::Member_def<vmp::fs::FileStat>
{
    pylib::Objref *def(vmp::fs::FileStat *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            vmp::Dev_t_wrap *dev_t=new vmp::Dev_t_wrap();
            try
            {
                instance->dev(dev_t);
            }
            catch(vmp::exception &x)
            {
                delete dev_t;
                vmp::except_s(x.what());    
            }
            return pylib::Converter<vmp::Dev_t_wrap *>(dev_t);
        }
        return 0;
    }
};

struct stub_FileStat_mode:public pylib::Member_def<vmp::fs::FileStat>
{
    pylib::Objref *def(vmp::fs::FileStat *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            vmp::fs::Mode_t_wrap *mode_t=new vmp::fs::Mode_t_wrap();
            try
            {
                instance->mode(mode_t);
            }
            catch(vmp::exception &x)
            {
                delete mode_t;
                vmp::except_s(x.what());    
            }
            return pylib::Converter<vmp::fs::Mode_t_wrap *>(mode_t);
        }
        return 0;
    }
};

struct stub_FileStat_rdev:public pylib::Member_def<vmp::fs::FileStat>
{
    pylib::Objref *def(vmp::fs::FileStat *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            vmp::Dev_t_wrap *dev_t=new vmp::Dev_t_wrap();
            try
            {
                instance->rdev(dev_t);
            }
            catch(vmp::exception &x)
            {
                delete dev_t;
                vmp::except_s(x.what());    
            }
            return pylib::Converter<vmp::Dev_t_wrap *>(dev_t);   
        }
        return 0;
    }
};

void vmp_init_fs(pylib::Module module)
{
    pylib::Module fs=module.add_submodule("fs");
    
    //vmp/lib/fs.h
    fs.def_("unlink_wrap",vmp::fs::unlink_wrap);
    fs.def_("format_dirpath",vmp::fs::format_dirpath);
    fs.def_with_stub("union_path",stub_union_path());
    fs.def_("chmod_wrap",vmp::fs::chmod_wrap);
    fs.def_("mkdir_wrap",vmp::fs::mkdir_wrap);
    fs.def_("rmdir_wrap",vmp::fs::rmdir_wrap);
    fs.def_("chdir_wrap",vmp::fs::chdir_wrap);
    fs.def_("isdir",vmp::fs::isdir);
    fs.def_("isrdir",vmp::fs::isrdir);
    fs.def_("iswdir",vmp::fs::iswdir);
    fs.def_("isxdir",vmp::fs::isxdir);
    fs.def_("getcwd_wrap",vmp::fs::getcwd_wrap);
    fs.def_("listendir",vmp::fs::listendir);
    fs.def_("isfile",vmp::fs::isfile);
    fs.def_("isrfile",vmp::fs::isrfile);
    fs.def_("iswfile",vmp::fs::iswfile);
    fs.def_("isxfile",vmp::fs::isxfile);
    fs.def_("file_ext",vmp::fs::file_ext);
    
    pylib::Class<vmp::fs::Mode_t_wrap> mode=fs.class_no_constructor<vmp::fs::Mode_t_wrap>("Mode_t_wrap");
    mode.def_("isreg",&vmp::fs::Mode_t_wrap::isreg);
    mode.def_("isdir",&vmp::fs::Mode_t_wrap::isdir);
    mode.def_("ischr",&vmp::fs::Mode_t_wrap::ischr);
    mode.def_("isblk",&vmp::fs::Mode_t_wrap::isblk);
    mode.def_("isfifo",&vmp::fs::Mode_t_wrap::isfifo);
    mode.def_("islnk",&vmp::fs::Mode_t_wrap::islnk);
    mode.def_("issock",&vmp::fs::Mode_t_wrap::issock);
    
    pylib::Class<vmp::fs::FileStat> filestat=fs.class_with_constructor<vmp::fs::FileStat>("FileStat",FileStat_Constructor());
    filestat.def_("reset",&vmp::fs::FileStat::reset);
    filestat.def_("set",&vmp::fs::FileStat::set);
    filestat.def_("filepath",&vmp::fs::FileStat::filepath);
    filestat.def_with_stub("dev",stub_FileStat_dev());
    filestat.def_("ino",&vmp::fs::FileStat::ino);
    filestat.def_with_stub("mode",stub_FileStat_mode());
    filestat.def_("nlink",&vmp::fs::FileStat::nlink);
    filestat.def_("uid",&vmp::fs::FileStat::uid);
    filestat.def_("gid",&vmp::fs::FileStat::gid);
    filestat.def_with_stub("rdev",stub_FileStat_rdev());
    filestat.def_("size",&vmp::fs::FileStat::size);
    filestat.def_("blksize",&vmp::fs::FileStat::blksize);
    filestat.def_("blocks",&vmp::fs::FileStat::blocks);
    filestat.def_("atime",&vmp::fs::FileStat::atime);
    filestat.def_("mtime",&vmp::fs::FileStat::mtime);
    filestat.def_("ctime",&vmp::fs::FileStat::ctime);
}

