/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/05/2024
 */

#ifndef VAMPIRIA_VMP_STRUCT_H

#define VAMPIRIA_VMP_STRUCT_H 1

namespace vampiria { namespace vmp {

//!Reset the vector and free up data storage space. The DATA type must be a pointer and allocated with vmp::malloc_wrap()
/*!
    @param vect pointer input vector
*/
template<class DATA>
void vector_free_alldata(vmp::vector<DATA> *vect)
{
    for(vmp_index i=0;i<vect->size();i++)
        vmp::free_wrap((void **)vect[i]);
    vect->clear();    
}

//!Reset the vector and delete up data storage space. The DATA type must be a pointer and allocated with new
/*!
    @param vect input vector
*/
template<class DATA>
void vector_delete_alldata(vmp::vector<DATA> *vect)
{
    for(vmp_index i=0;i<vect->size();i++)
        delete (*vect)[i];
    vect->clear();
}

}}

#endif

