/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/12/2019
 */

#include <signal.h>

#ifndef VAMPIRIA_VMP_SIGNAL_H

#define VAMPIRIA_VMP_SIGNAL_H 1

namespace vampiria { namespace vmp {

//!It takes in input a signal in string mode ex. ("sigint") and returns the integer that identifies the signal
/*!
    @param sigstr signal in string mode
    @return integer that identifies the signal
*/
vmp_int signum(vmp::str sigstr);

//!It takes as input a signal in integer format and transforms it into string format
/*!
    @param sig signale input
    @return signal in string mode
*/
vmp::str sigstr(vmp_int sig);

//!Checks whether the signal in string format coincides with the signal in integer format
/*!
    @param sig  signal in string format
    @param isig signal in integer format
    @return true if they coincide,otherwise false
*/
vmp_bool sigcmp(vmp::str sig,vmp_int isig);

//!Assign a list of signals to a callback function
/*!
    @param sig signal list in string mode("sigint")
    @param callback callback function
    @return void (except error)
*/
void signal_wrap(vmp::vector<vmp::str> sig,void (*callback)(vmp_int));

//!blocks list signals (called in threads)
/*!
    @param ig signal list in string mode("sigint")
    @return void (except error) 
*/
void pthread_sigblock_wrap(vmp::vector<vmp::str> sig);//-lpthread in compile and pthread.h

}}

#endif

