/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/05/2024
 */

#include "vmp.h"

namespace vampiria { namespace vmp {

void sleep_wrap(vmp_uint seconds)
{
    sleep(seconds);
}

void pause_wrap()
{
    pause();
}

void usleep_wrap(vmp_uint useconds)
{
    usleep(useconds);
}

vmp::Pid fork_wrap()
{
    vmp::Pid ret=fork();
    if(ret == -1)
        vmp::except_errno();
    return ret;
}

vmp::Pid getpid_wrap()
{
    return getpid();
}

vmp::Uid getuid_wrap()
{
    return getuid();
}

vmp::Uid geteuid_wrap()
{
    return geteuid();
}

void kill_wrap(vmp::Pid pid,vmp::str sig)
{
    vmp_assert(_POSIX_C_SOURCE);
    kill(pid,vmp::signum(sig));	
}

vmp_int waitpid_wrap(vmp::Pid *pid)
{
    vmp_int status;
    vmp::Pid p=(*pid);
    (*pid) = -1;
    if((p != -1) && (waitpid(p,&status,0) != -1))
        return WEXITSTATUS(status);
    return -1;
}

void pipe_wrap(vmp_int *piper,vmp_int *pipew)
{
    vmp_int p[2];
    if(pipe(p) == -1)
	vmp::except_errno();
    (*piper)=p[0];
    (*pipew)=p[1];
}

void pty_wrap(vmp_int *master,vmp_int *slave)
{
    //-lutil
    if(openpty(master,slave,0,0,0) == -1)
        vmp::except_errno();   
}

void system_wrap(vmp::str cmd)
{
    vmp_int ret=system(cmd.c_str());
    if(ret != 0)
       vmp::except("Exec system command '%s' error",cmd.c_str());
}

void execve_wrap(vmp::str filename, vmp_char *const argv[],vmp_char *const envp[])
{
    if(execve(filename.c_str(),argv,envp) == -1)
       vmp::except_errno();
}

vmp_int getopt_wrap(vmp_int argc, vmp_char *const argv[],vmp::str optstring)
{
    vmp_assert(_POSIX_C_SOURCE >= 2 || _XOPEN_SOURCE);
    return getopt(argc,argv,optstring.c_str());
}  

}}

