/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/05/2024
 */
 
#ifndef VAMPIRIA_VMP_LIB_DEV_H

#define VAMPIRIA_VMP_LIB_DEV_H 1

namespace vampiria { namespace vmp {

//!Manipulates the underlying device parameters of socket interface to configure network device
/*!
    @param sock input socket
    @param ifname interface name
    @param request request code
    @param ifr pointer to interface structure(see man linux)
    @return void or except in case of failure
*/
void ioctl_wrap_ifreq(vmp_int sock,vmp::str ifname,vmp_uint request,struct ifreq *ifr);

//! c dev_t structure wrapper describing a device id.A device ID consists of two parts: a major ID, identifying the class of
//! the device, and a minor ID, identifying a specific instance of a device
//! in that class
class Dev_t_wrap
{
    private:
        vmp_uint major_;/*!<major id*/
        vmp_uint minor_;/*!<minor id*/
    public:
        //! A constructor
        Dev_t_wrap();
        
        //! A destructor
        ~Dev_t_wrap();
        
        //! Set the device id
        /*
            @param major major id
            @param minor minor id
        */
        void set_values(vmp_uint major,vmp_uint minor);
        
        //! Set the device id from structure dev_t
        void set(dev_t dev);
        
        //! Returns major id
        vmp_uint get_major();
        
        //! Return minor id
        vmp_uint get_minor();
        
        //! Returns the structure dev_t
        dev_t get_dev();
};

}}

#endif

