/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/02/2020
 */

#include "vmp.h"

namespace vampiria { namespace vmp { namespace args {

GetOpt::GetOpt()
{
}

GetOpt::~GetOpt()
{
    opt_.clear();
}

void GetOpt::set_opt(vmp_char opt,vmp::args::GETOPTCB cb,vmp_bool optarg)
{
    vmp::pair<vmp::args::GETOPTCB,vmp_bool> data(cb,optarg);
    try
    {
        opt_.insert(opt,data);
    }
    catch(vmp::exception &x)
    {
        vmp::except("vmp::args::Getopt::set_opt duplicate opt %c",opt);     
    }
}

void GetOpt::parse(vmp_int argc,vmp_char *const argv[])
{
    vmp::str strinput="";
    vmp::vector<vmp_char> opt=opt_.all_keys();
    vmp::pair<vmp::args::GETOPTCB,vmp_bool> data;
    for(vmp_index i=0;i<opt.size();i++)
    {
        opt_.search(opt[i],&data);
        if(data.second)
            vmp::unicode::str_cwrite(&strinput,"%c:",opt[i]);
        else
            vmp::unicode::str_cwrite(&strinput,"%c",opt[i]);
    }
    vmp_int c;
    while ((c=getopt(argc,argv,strinput.c_str())) != -1)
    {
        if(c == '?')
        {
            if(opt_.search(optopt,&data))
                vmp::except("vmp::args::GetOpt::parse Option -%c required an argument",optopt);
            else
                vmp::except("vmp::args::GetOpt::parse Unknown option -%c",optopt);
        }
        else
        {
            opt_.search(c,&data);
            if(data.second)
                data.first(argc,argv,optarg);
            else
                data.first(argc,argv,0);       
        }
    }
} 

Envp::Envp()
{
}

Envp::Envp(vmp_char *envp[])
{
    vmp::str name;
    while(*envp)
    {
        insert_data((*envp),false);
        envp++;
    }
}
        
Envp::~Envp()
{
    data_.clear();
}

vmp::str Envp::integrity(vmp::str value)
{
    vmp::str name="",error;
    vmp_index i;        
    if(value.size() > vmp::POSIX_ARG_MAX)
        vmp::except("vmp::args::Envp::integrity Enviroment variable '%s' too long",value.c_str());
    for(i=0;i<value.size();i++)
    {    
        if((value[i] == '=') && (name==""))
            return value.substr(0,i);
        else if(value[i] <= 0x20)
            break;
    }
    vmp::except("vmp::args::Envp::integrity Enviroment variable '%s' invalid syntax",value.c_str());
    return name; 
}

Envp& Envp::operator=(Envp env)
{
    data_.clear();
    vmp::vector<vmp::str> envdata=env.get_data();
    for(vmp_index i=0;i<envdata.size();i++)
       insert_data(envdata[i],false);     
    return (*this);
}

vmp::str Envp::insert_data(vmp::str value,vmp_bool replace)
{
    vmp::str name=integrity(value);
    vmp::str result;
    if(replace)
       data_.cancel(name,&result);
    else if(data_.search(name,&result))
        vmp::except("vmp::args::Envp::integrity Enviroment variable '%s' duplicate value",value.c_str());
    data_.insert(name,value);
    return name;
} 

vmp::str Envp::get_data(vmp::str name)
{
    vmp::str ret="";
    if(!data_.search(name,&ret))
        vmp::except("vmp::args::Envp::get_data(name) Enviroment variable name '%s' not found",name.c_str());
    return ret;
}

vmp::vector<vmp::str> Envp::get_data()
{
    return data_.all_data();
}

void Envp::preload_local_lib(vmp::str libname)
{
    vmp::str libpath;
    try
    {
        libpath=vmp::env::vampiria_lib(libname);
    }
    catch(vmp::exception &x)
    {
        vmp::except("vmp::args::Envp::preload_local_lib Library '%s' not installed",libname.c_str());
    }
    vmp::str preload=get_data("LD_PRELOAD");
    if(preload == "")
        vmp::unicode::str_write(&preload,"LD_PRELOAD=%s",libpath.c_str());
    else if(!vmp::unicode::str_findsub(preload,libpath))
        vmp::unicode::str_write(&preload,"%s %s",preload.c_str(),libpath.c_str());
    insert_data(preload,true);
}

}}}

