/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/01/2020
 */

#include "pylib.h"

namespace vampiria { namespace pylib {

CArgs::CArgs(vmp_size size)
{
    list_=pylib::pylist_new(size);
    size_=size;
    index_=0;
}
        
CArgs::~CArgs()
{
    pylib::pylist_clear(list_);
    list_=0;
    size_=0;
    index_=0;
}

pylib::Objref *CArgs::get_args()
{
    if(index_ != size_)
       vmp::except_s("Pylib::CArgs error 'invalid number arguments'");
    return pylib::pylist_astuple(list_);
} 

CKwArgs::CKwArgs()
{
    dict_=pylib::pydict_new();
}
       
CKwArgs::~CKwArgs()
{
    pylib::pydict_clear(dict_);
    dict_=0;
}

pylib::Objref *CKwArgs::get_kwargs()
{
    return dict_;
}

PyObj::PyObj()
{
    ref_=0;
}

PyObj::~PyObj()
{
    reset();	
}

const PyObj &PyObj::operator=(PyObj &obj)
{
    if(!pylib::is_null(obj.ref_))
        set(obj.ref_);
    return (*this);
}

void PyObj::reset()
{
    if(!pylib::is_null(ref_))
    {
	pylib::decref(ref_);
	ref_=0;
    }
     
}

void PyObj::set(pylib::Objref *ref)
{
     reset();
     if(pylib::is_null(ref))
        vmp::except_s("PyObj::set input objref null");
     ref_=ref;
     pylib::incref(ref_);
}
        
pylib::Objref *PyObj::ref()
{
    if(pylib::is_null(ref_))
        vmp::except_s("PyObj::ref null object in references");
    return ref_;
}

vmp_bool PyObj::is_none()
{
    return pylib::is_none(ref_);
}

PyObj PyObj::get_attr(vmp::str name)
{
     PyObj ret;
     pylib::Objref *th=ref();
     try
     {
         pylib::Objref *obj=pylib::pyobj_getattr_obj(th,name);
         ret.set(obj);
     }
     catch(vmp::exception &x)
     {
	 vmp::except("PyObj::get_attr invalid attribute name '%s'",name.c_str());     
     }
     return ret;
}

PyCall::PyCall()
{
    callable_=0;
}
       
PyCall::~PyCall()
{
    reset();
}

const PyCall &PyCall::operator=(PyCall &obj)
{
    if(!pylib::is_null(obj.callable_))
        set(obj.callable_);
    return (*this);
}

void PyCall::reset()
{
    if(!pylib::is_null(callable_))
    {
        pylib::decref(callable_);
        callable_=0;
    }
}

void PyCall::set(pylib::Objref *callable)
{
    reset();
    if(pylib::is_null(callable))
        vmp::except_s("PyCall::set input objref null");
    if((!pylib::is_none(callable)) && (!pycallable_check(callable)))
        vmp::except_s("PyCall::set input objref not callable");
    callable_=callable;
    pylib::incref(callable_);
}

pylib::Objref *PyCall::ref()
{
     if(pylib::is_null(callable_))
        vmp::except_s("PyCall::ref null object in references");
     return callable_;
}

Args::Args(pylib::Objref *tuple,vmp_index init)
{
    if(!pytuple_check(tuple))
        vmp::except_s("vampiria::pylib fatal error input args");
    tuple_=tuple;
    tsize_=pylib::pytuple_size(tuple);
    init_=init;
    if(tsize_ > init_)
        size_=tsize_-init_;
    else
        size_=0;
    argerr_=-1;
}
          
Args::~Args()
{
    tuple_=0;
}

vmp_size Args::size()
{
    return size_;
}

void Args::arg_error()
{
    if(argerr_ >= (vmp_int) size_)
        vmp::except_args_s("");
    else if (argerr_ != -1)
        vmp::except_args("%d",argerr_);
}

vmp_bool Args::is_none(vmp_index i)
{
    pylib::PyObj tmp;
    if(i < size_)
    {
        try
        {
            tmp.set(pylib::pytuple_getitem(tuple_,init_+i));
            return tmp.is_none();
        }
        catch(vmp::exception &x)
        {
        } 
    }
    if(argerr_ < (vmp_int) i) 
        argerr_=(vmp_int) i;
    arg_error();
    return false;
}

void Args::get_obj(vmp_index i,pylib::PyObj &ret)
{
    if(i < size_)
    {
        try
        {
            ret.set(pylib::pytuple_getitem(tuple_,init_+i));
            return;
        }
        catch(vmp::exception &x)
        {         
        } 
    }
    if(argerr_ < (vmp_int) i) 
        argerr_=(vmp_int) i;
    arg_error();
}
	
void Args::get_obj_member(vmp_index i,vmp::str objname,pylib::PyObj &ret)
{
    if(i < size_)
    {
        try
        {
            pylib::Objref *member=pylib::pytuple_getitem(tuple_,init_+i);
            pylib::Objref *obj=pylib::pyobj_getattr_obj(member,objname);
            ret.set(obj);
            return;
        }
        catch(vmp::exception &x)
        {         
        } 
    }
    if(argerr_ < (vmp_int) i) 
        argerr_=(vmp_int) i;
    arg_error();    
}

void Args::get_callable(vmp_index i,pylib::PyCall &ret)
{
    if(i < size_)
    {
        try
        {
            ret.set(pylib::pytuple_getitem(tuple_,init_+i));
            return;
        }
        catch(vmp::exception &x)
        {         
        } 
    }
    if(argerr_ < (vmp_int) i) 
        argerr_=(vmp_int) i;
    arg_error();
}

void Args::get_callable_member(vmp_index i,vmp::str funcname,pylib::PyCall &ret)
{
    if(i < size_)
    {
        try
        {
            pylib::Objref *member=pylib::pytuple_getitem(tuple_,init_+i);
            pylib::Objref *callable=pylib::pyobj_getattr_obj(member,funcname);
            ret.set(callable);
            return;
        }
        catch(vmp::exception &x)
        {         
        } 
    }
    if(argerr_ < (vmp_int) i) 
        argerr_=(vmp_int) i;
    arg_error();
}

KwArgs::KwArgs(pylib::Objref *dict)
{
    dict_=dict;
}

KwArgs::~KwArgs()
{
    dict_=0;
}

}}

