/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 03/09/2024
 */

#ifndef VAMPIRIA_PACKET_STR_H

#define VAMPIRIA_PACKET_STR_H 1

namespace vampiria { namespace packet {

//! Datatype String
class DataStr:public packet::DataBytes
{
    protected:
        vmp::str data_;/*!<data*/
    public:
        //! A constructor
        /*!
            @param field data field
        */
        DataStr(vmp::str field);
        
        //! A destructor
        ~DataStr();
        
        //! Virtual function
        vmp::str get(vmp::str field);
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        void read(vmp::Buf *buf);
        
        //! Virtual function
        void write(vmp::Buf *buf);
};

//! Data string select mode
class DataStrSelect:public packet::DataStr
{
    protected:
        vmp::Table<vmp::str,void *> values_;/*!<accepted values*/
    public:
        //! A constructor
        /*!
            @param field data field
            @param values accepted values
        */
        DataStrSelect(vmp::str field,vmp::vector<vmp::str> values);
        
        //! A destructor
        ~DataStrSelect();
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        void read(vmp::Buf *buf);    
};

//! Data string accepted if regular expression is valid
class DataStrRegex:public packet::DataStr
{
    protected:
        vmp::str regex_;/*!<regex string*/
    public:
        //! A constructor
        /*!
            @param field data field
            @param regex regex string accepted
        */
        DataStrRegex(vmp::str field,vmp::str regex);
        
        //! A destructor
        ~DataStrRegex();
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        void read(vmp::Buf *buf);    
};

}}

#endif

