/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 03/09/2024
 */

#include "packet.h"

namespace vampiria { namespace packet {

DataStr::DataStr(vmp::str field):packet::DataBytes(field)
{
    data_="";
}

DataStr::~DataStr()
{
    data_="";
}

vmp::str DataStr::get(vmp::str field)
{
    return data_;
}
        
void DataStr::set(vmp::str field,vmp::str data)
{
    data_=data;
}
        
void DataStr::read(vmp::Buf *buf)
{
    data_=buf->read_str(buf->size_reading());
}
        
void DataStr::write(vmp::Buf *buf)
{
   if(data_ != "")
     buf->write_str(data_);
}

DataStrSelect::DataStrSelect(vmp::str field,vmp::vector<vmp::str> values):packet::DataStr(field)
{
    for(vmp_index i=0;i<values.size();i++)
    {
        try
        { 
            values_.insert(values[i],0);
        }
        catch(vmp::exception &x)
        {
        }
    }
}

DataStrSelect::~DataStrSelect()
{
    values_.clear();
    data_="";
}

void DataStrSelect::set(vmp::str field,vmp::str data)
{
    void *ret;
    if(values_.search(data,&ret))
        data_=data;
    else
        vmp::except_s("Malformed Data String Select");
}

void DataStrSelect::read(vmp::Buf *buf)
{
    vmp::str tmp=buf->read_str(buf->size_reading());
    void *ret;
    if(values_.search(tmp,&ret))
        data_=tmp;
    else
        vmp::except_s("Malformed Recv Data String Select");
    
}

DataStrRegex::DataStrRegex(vmp::str field,vmp::str regex):packet::DataStr(field)
{
    regex_=regex;
}

DataStrRegex::~DataStrRegex()
{
    regex_="";
    data_="";
}

void DataStrRegex::set(vmp::str field,vmp::str data)
{
    if(vmp::unicode::str_regex_matching(data,regex_))
        data_=data;
    else
        vmp::except_s("Malformed Data String Regex");
}

void DataStrRegex::read(vmp::Buf *buf)
{
    vmp::str tmp=buf->read_str(buf->size_reading());
    if(vmp::unicode::str_regex_matching(tmp,regex_))
        data_=tmp;    
    else    
        vmp::except_s("Malformed Recv Data String Select");
}
}}

