/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/10/2024
*/

#include "jrp.h"

namespace vampiria { namespace jrp {

void wssjrpui_tcpacceptcb(event::Cell *cell,event::Cell *child)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::WssJrpUI *ui=cell->ui<jrp::WssJrpUI>();
    ui->set_jrp_event(child);
    crypto::EventWss *wss=child->event<crypto::EventWss>();
    try
    {
        vmp::utils::Logger *logger=ui->logger();
        net::Address *peer=wss->evt_connection_peeraddr();
        logger->write(vmp::utils::LOG_INFO,"wssjrp_accept(peer='%s:%s')",peer->host().c_str(),peer->service().c_str());
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->tcpaccept_(cell,child);
    }
    catch(vmp::exception &x)
    {
    }
}

void wssjrpui_sessioncb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::WssJrpUI *ui=cell->ui<jrp::WssJrpUI>();
    crypto::EventWss *wss=cell->event<crypto::EventWss>();
    try
    {
        vmp::utils::Logger *logger=ui->logger();
        net::Address *peer=wss->evt_connection_peeraddr();
        logger->write(vmp::utils::LOG_INFO,"wssjrp_session(peer='%s:%s',user='%s',permits=%u)",peer->host().c_str(),peer->service().c_str(),wss->sub_->sessionid_.c_str(),wss->sub_->sessionpermits_);
        
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->session_(cell);
    }
    catch(vmp::exception &x)
    {
    }
}

void close_log(event::Cell *cell,jrp::WssJrpUI *ui,vmp::str addrtype)
{
    crypto::EventWss *wss=cell->event<crypto::EventWss>();
    vmp::utils::Logger *logger=ui->logger();
    net::Address *addr;
    if(addrtype == "local")
        addr=wss->evt_connection_localaddr();
    else
        addr=wss->evt_connection_peeraddr();
    vmp::str strtype=wss->evt_connection_strtype();
    if(cell->ret_ == event::SUCCESS)
        logger->write(vmp::utils::LOG_INFO,"%s_wssjrp_close(%s='%s:%s') [level='%s','OK']",strtype.c_str(),addrtype.c_str(),addr->host().c_str(),addr->service().c_str(),cell->closelevel_.c_str());
    else if(cell->ret_ == event::TIMEOUT)
        logger->write(vmp::utils::LOG_ERR,"%s_wssjrp_close(%s='%s:%s') ['Timeout']",strtype.c_str(),addrtype.c_str(),addr->host().c_str(),addr->service().c_str());
    else
        logger->write(vmp::utils::LOG_ERR,"%s_wssjrp_close(%s='%s:%s')[level='%s',errcode=%d,errmsg='%s']",strtype.c_str(),addrtype.c_str(),addr->host().c_str(),addr->service().c_str(),cell->closelevel_.c_str(),cell->errcode_,cell->err_.c_str());
}

void wssjrpui_lclosecb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::WssJrpUI *ui=cell->ui<jrp::WssJrpUI>();
    try
    {
        jrp::close_log(cell,ui,"local");
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->closelisten_(cell);
    }
    catch(vmp::exception &x)
    {
    }
}

void wssjrpui_sclosecb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::WssJrpUI *ui=cell->ui<jrp::WssJrpUI>();
    try
    {
        jrp::close_log(cell,ui,"peer");
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->closeserver_(cell);
    }
    catch(vmp::exception &x)
    {
    }
}

}}

