/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#ifndef VAMPIRIA_EVENT_SIMPLEXUI_H

#define VAMPIRIA_EVENT_SIMPLEXUI_H 1

namespace vampiria { namespace event {

//!Event used from Simplexui
class SimplexRef:public event::EventSimplex
{
    public:
        //!A Constructor
        SimplexRef();
        
        //!A Destructor
        ~SimplexRef();

        vmp::str id_;/*!<id event*/
};

//!Input User interface
class SimplexUI:public event::UI
{
     private:
        vmp::utils::Storage<SimplexRef> sref_;/*!<Storage event*/
        event::EVTCB event_;/*!Callback event*/
        event::EVTCB cevent_;/*!Close Event*/   
     public:
        //!A Constructor
        /*!
            @param manager input manager
        */
        SimplexUI(event::Manager *manager);
        
        //!A Destructor
        ~SimplexUI();

        //!Virtual class implemented
        vmp::str identity(event::Cell *cell);
        
        //!Virtual class implemented
        void close_event(event::Cell *cell);
        
        //!Virtual class implemented
        void free_ref(event::Cell *cell);

        //!Set Simplex event
        /*!
            @param event callback event active
            @param cevent callback close event 
        */
        void set_event(event::EVTCB event,event::EVTCB cevent);

        //!Create new simplex event
        /*!
            @param id id event
            @return cell associated with event(except error)
        */
        event::Cell *new_event(vmp::str id);

        //!Active event associated with cell
        /*!
            @param cell cell associated
        */
        void active(event::Cell *cell);
        
        //!Returns id event
        /*!
            @param cell cell associated
            @return id event
        */
        vmp::str id(event::Cell *cell);
};

}}

#endif

