/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 14/01/2023
 */

#ifndef VAMPIRIA_EVENT_EVENTTHREAD_H

#define VAMPIRIA_EVENT_EVENTTHREAD_H 1

namespace vampiria { namespace event {

class EventThread;

//!Thread associated with EventThread and EventThreadBuf
class ThreadEv:public vmp::thread::Thread
{
    private:
        void cancel_impl();
    public:
        //! A Constructor
        ThreadEv();
        
        //!A Destructor
        ~ThreadEv();
      
        event::EventPipe *event_;/*<Event thread or event ThreadBuf*/
        event::Cell *cell_;/*<References cell*/
        event::EVTCB run_;/*<Callback performed by the thread*/
        event::EVTCB cancel_;/*<Callback performed by the cancel*/

        //!Virtual run derivated
        void run();
};

//!Event Thread
class EventThread:public event::EventPipe
{
    public:
       //! A Constructor
       EventThread();

       //! A Destructor
       ~EventThread();

       ThreadEv thread_;/*!<Thread associated*/
       vmp_bool cancel_;/*!<Used in closing to understand if the thread should be deleted*/
       event::EVTCB active_;/*!<Callback call when activating the main event*/
       event::EVTCB close_;/*!Close thread callback*/
 
       //!Create thread event
       /*!
            @param  ui user interface (see Class UI)
            @param  active callback performed when activating the main event
            @param  run   callback performed in the thread run
            @param  close callback performed at the end of the event
            @return the new cell associated with the event
       */
       event::Cell *evt_thread_new(event::UI *ui,event::EVTCB active,event::EVTCB run,event::EVTCB cancel,event::EVTCB close);

       //! Activating the main thread event 
       void evt_thread_active();

       //! Start thread event
       void evt_thread_start();

       //! Close thread event
       void evt_thread_close();

       //! Free thread event
       void evt_thread_free();
};

//!A thread event used to read messages on the thread that you created and with the callback running on the main thread.
//!The created event uses a queue to post messages and triggers the main event
class EventThreadBuf:public event::EventPipe
{
    public:
        //! A Constructor
        EventThreadBuf();

        //! A Destructor
        ~EventThreadBuf();

        vmp::queue<vmp::Buf *> queue_;/*!<Message queue*/
        vmp::utils::Storage<vmp::Buf> bufs_;/*!<Buffer storage*/
        ThreadEv thread_;/*!<Thread associated*/
        vmp_bool cancel_;/*!<Used in closing to understand if the thread should be deleted*/
        event::EVTCBBUF recv_;;/*!<Callback call when recv buf in queue in the main event*/
        event::EVTCB close_;/*!Close thread callback*/

        //!Create thread event
        /*!
            @param  ui user interface (see Class UI)
            @param  recv  callback call when recv buf in queue in the main event
            @param  run   callback performed in the thread run
            @param  close callback performed at the end of the event
            @return the new cell associated with the event
        */
        event::Cell *evt_threadbuf_new(event::UI *ui,event::EVTCBBUF recv,event::EVTCB run,event::EVTCB cancel,event::EVTCB close);

        //! Queue an event and trigger the main event(must be inserted in a manager lock)
        /*!
            @param buf message buffer
        */
        void evt_threadbuf_send(vmp::Buf *buf);

        //! Start thread event
        void evt_threadbuf_start();

        //! Close thread event
        void evt_threadbuf_close();

        //! Free thread event
        void evt_threadbuf_free();
};

}}

#endif

