/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 25/10/2024
 */

#ifndef VAMPIRIA_EVENT_EVENTINPUT_H

#define VAMPIRIA_EVENT_EVENTINPUT_H 1

namespace vampiria { namespace event {

//!Event that reads standard input
class EventInput:public event::Event
{
    public:
        //!A Constructor
        EventInput();

        //!A Destructor
        ~EventInput();

        event::EVTCBSTR iread_;/*!<input read callback*/
        vmp_bool enable_;/*<is the input reading enable?*/

        //!Create a new event input
        /*!
            @param  ui    user interface (see Class UI)
            @param  iread callback performed on receipt of data(line data)
            @param  close function performed at the end of the event
            @return the new cell associated with the event(except error)
        */
        event::Cell *evt_input_new(event::UI *ui,event::EVTCBSTR iread,event::EVTCB close);

        //! Close Input event
        void evt_input_close();

        //! Free Input event
        void evt_input_free();
};

}}

#endif

