/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 06/09/2024
 */

#ifndef VAMPIRIA_CRYPTO_LIB_H

#define VAMPIRIA_CRYPTO_LIB_H 1

namespace vampiria { namespace crypto {

const vmp::str pkeypem_="pkey.pem";/*!<Pem private key name in this package*/
const vmp::str x509pem_="x509.pem";/*!<Pem certificate name in this package*/

//! Returns string error openssl
vmp::str err_string();

//! Utility function to write the data of a BIO openssl in a vampiria buffer
/*!
     @param bio input bio
     @param buf output buf
     @return data size or 0 close or except in case of failure
*/
vmp_int bio_to_buf(BIO *bio,vmp::Buf *buf);

//! Utility function to write the data of a a vampiria buffer in a BIO openssl 
/*!
     @param buf input buf
     @param bio output bio
     @return data size or 0 close bio or except in case of failure
*/
vmp_int buf_to_bio(vmp::Buf *buf,BIO *bio);

//!Utility used to compute hash functions
/*!
    @param buf input buffer
    @param delimiter byte delimiter
    @param type evp hash type(see openssl lib ex. EVP_sha256())
    @return hash value or except in case of failure
*/
vmp::str evp_digest_bin(vmp::Buf *ibuf,vmp::str delimiter,const EVP_MD *type);

//!Utility used to compute hash functions
/*!
    @param istr input string
    @param delimiter byte delimiter
    @param type evp hash type(see openssl lib ex. EVP_sha256())
    @return hash value or except in case of failure
*/
vmp::str evp_digest(vmp::str istr,vmp::str delimiter,const EVP_MD *type);

}}

#endif

