/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 16/09/2024
 */

#include "crypto.h"

namespace vampiria { namespace crypto {

void framing_recv_default(event::Cell *cell,vmp::Buf *buf)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    crypto::EventSsl *ssl=cell->event<crypto::EventSsl>();
    ssl->evt_ssl_framing_close(packet::websocket::WebSocketCode_Type);
    manager->unlock();   
}

void framing_ping(void *ref)
{
    crypto::EventSsl *ssl=(crypto::EventSsl *) ref;
    event::Manager *manager=ssl->cell_->get_manager();
    event::Cell *ping;
    manager->lock();
    ping=manager->cell_searchsub(ssl->cell_,"framing_ping");
    if(ssl->timeping_ == 0)
    {
        vmp::Buf buf;
        ssl->timeping_=manager->time_now();
        ssl->framing_.send_ping(ssl->common_->framing_pinglenbody_);
        if(!ssl->cell_->writing_)
            ssl->evt_ssl_framing_next();
        ssl->common_->routine_active(ping,ssl->common_->framing_ptimeout_);
    }
    else
        manager->cell_close(ssl->cell_,event::TIMEOUT);
    manager->unlock();
}

void framing_read(event::Cell *cell)
{
    vmp_bool exec=false;
    vmp::Buf buf;
    event::Cell *ping;
    event::Manager *manager=cell->get_manager();
    manager->lock();
    crypto::EventSsl *ssl=cell->event<crypto::EventSsl>();
    if(cell->writing_)
        ssl->evt_ssl_framing_next();
    try
    {
        vmp_int ret=ssl->ssl_.recv(&buf);
        if(ret == 0)
            manager->cell_close_ok_spec(cell,"crypto::EventSsl");
        else if(ret > 0)
            exec=manager->cell_update(cell);
        else if(ret == -1)
            manager->cell_close_err_spec(cell,"crypto::EventSsl",ssl->ssl_.get_errno(),crypto::err_string());
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"crypto::EventSsl",0,x.what());
    }
    if(exec)
    {
        vmp::Buf out;
        vmp::str err;
        vmp_uint code=ssl->framing_.parse(&buf,&ssl->framingcode_,&err,&out,ssl->common_->framing_maxsize_,ssl->common_->framing_maxn_);
        while(code != 0x00)
        {
            switch(code)
            {
                case 0x01:
                    //text callback
                    manager->unlock();
                    ssl->common_->framing_recv_text_(cell,&out);
                    manager->lock();
                    break;
                case 0x02:
                    //bin callback
                    manager->unlock();
                    ssl->common_->framing_recv_bin_(cell,&out);
                    manager->lock();
                    break;
                case 0x08:
                    //close callback
                    if(ssl->framingcode_ >= 3000 && ssl->framingcode_ <= 3099)
                        ssl->framingcode_-=2000;
                    if(ssl->framingcode_ == packet::websocket::WebSocketCode_Normal)
                        manager->cell_close_ok_spec(cell,"crypto::EventSslFramingPeer");
                    else
                        manager->cell_close_err_spec(cell,"crypto::EventSslFramingPeer",ssl->framingcode_,err);   
                    break;
                case 0x09:
                    if(!cell->writing_)
                        ssl->evt_ssl_framing_next();
                    break;
                case 0x0A:
                    ssl->timeping_=0;
                    ping=manager->cell_searchsub(ssl->cell_,"framing_ping");
                    ssl->common_->routine_active(ping,ssl->common_->framing_rtimeout_);
                    break;
                default:
                    //error read
                    manager->cell_close_err_spec(cell,"web::EventSslFraming",ssl->framingcode_,err);   
                    manager->unlock();
                    return;
             }
             code=ssl->framing_.parse(0,&ssl->framingcode_,&err,&out,ssl->common_->framing_maxsize_,ssl->common_->framing_maxn_);
        }
    }
    manager->unlock();
}

}}

