/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/09/2024
 */

#include "packet_.h"
void packet_init_websocket(pylib::Module module)
{
    pylib::Module ws=module.add_submodule("websocket");
    ws.add_const<vmp_index>("WebSocketCode_Normal",packet::websocket:: WebSocketCode_Normal);
    ws.add_const<vmp_index>("WebSocketCode_Shutdown",packet::websocket::WebSocketCode_Shutdown);
    ws.add_const<vmp_index>("WebSocketCode_Protocol",packet::websocket::WebSocketCode_Protocol);
    ws.add_const<vmp_index>("WebSocketCode_Type",packet::websocket::WebSocketCode_Type);
    ws.add_const<vmp_index>("WebSocketCode_Utf8",packet::websocket::WebSocketCode_Utf8);
    ws.add_const<vmp_index>("WebSocketCode_Policy",packet::websocket::WebSocketCode_Policy);
    ws.add_const<vmp_index>("WebSocketCode_Big",packet::websocket::WebSocketCode_Big);
    ws.add_const<vmp_index>("WebSocketCode_Extension",packet::websocket::WebSocketCode_Extension);
    ws.add_const<vmp_index>("WebSocketCode_Unexpected",packet::websocket::WebSocketCode_Unexpected);
    ws.def_("WebSocketCode_reason",packet::websocket::WebSocketCode_reason);
    ws.add_const<vmp::str>("P_WEBSOCKET_FRAMING",packet::websocket::P_WEBSOCKET_FRAMING);
    ws.def_("WebSocket_Framing_D",packet::websocket::WebSocket_Framing_D,false);
    ws.def_("WebSocket_Framing_Ping",packet::websocket::WebSocket_Framing_Ping,false);
    ws.def_("WebSocket_Framing_Pong",packet::websocket::WebSocket_Framing_Pong,false);
    ws.def_("WebSocket_Framing_Close",packet::websocket::WebSocket_Framing_Close,false);
}

