/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#include "event_.h"

class PySimplexUI:public event::SimplexUI
{
   public:
        PySimplexUI(event::Manager *manager);
        ~PySimplexUI();

        pylib::PyCall pyevent_;
        pylib::PyCall pycevent_;
};

PySimplexUI::PySimplexUI(event::Manager *manager):event::SimplexUI(manager)
{
}

PySimplexUI::~PySimplexUI()
{
}

struct stub_simplexui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PySimplexUI *>(cell->ui<PySimplexUI>(),false);

        }
        return 0;
    }
};

struct SimplexUI_Constructor:public pylib::Constructor<PySimplexUI>
{
    PySimplexUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
              event::Manager *manager=args.get<event::Manager *>(0);
              return new PySimplexUI(manager);
         }
         return 0;
    }
};

void simplex_pyevent(event::Cell *cell)
{
    PySimplexUI *simplexui=cell->ui<PySimplexUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    simplexui->pyevent_.call(cargs);
}

void simplex_pycevent(event::Cell *cell)
{
    PySimplexUI *simplexui=cell->ui<PySimplexUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    simplexui->pycevent_.call(cargs);
}

struct stub_SimplexUI_set_event:public pylib::Member_def<PySimplexUI>
{
    pylib::Objref *def(PySimplexUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            event::EVTCB event;
            event::EVTCB cevent;
            
            args.get_callable(0,instance->pyevent_);
            args.get_callable(1,instance->pycevent_);
            
            if(pylib::is_none(instance->pyevent_.ref()))
               event=0;
            else 
               event=simplex_pyevent;
            if(pylib::is_none(instance->pycevent_.ref()))
               cevent=0;
            else 
               cevent=simplex_pycevent;
            instance->set_event(event,cevent);
            return pylib::retnone();                      
        }
        return 0;
    }
};

void event_init_simplexui(pylib::Module module)
{
    //Wrapper cell->ui()
    module.def_with_stub("simplexui",stub_simplexui());
    pylib::Class<PySimplexUI> simplexui=module.class_with_constructor<PySimplexUI>("SimplexUI",SimplexUI_Constructor());
    simplexui.def_with_stub("set_event",stub_SimplexUI_set_event());
    simplexui.def_("new_event",&PySimplexUI::new_event,false);
    simplexui.def_("active",&PySimplexUI::active);
    simplexui.def_("id",&PySimplexUI::id);
}


