/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/09/2024
 */
 
#include "vmp_.h"

struct stub_pairliststr_cancel:public pylib::Member_def<vmp::PairList<vmp::str,vmp::str> >
{
    pylib::Objref *def(vmp::PairList<vmp::str,vmp::str> *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp_bool isstr=true;
            vmp::str sarg="";
            vmp_index iarg=0;
            try
            {
                sarg=args.get<vmp::str>(0);
            }
            catch(vmp::exception &x)
            {
                isstr=false;
                iarg=args.get<vmp_index>(0);
            }
            if(isstr)
                return pylib::Converter<vmp_index>(instance->cancel(sarg));
            return pylib::Converter<vmp_index>(instance->cancel(iarg));
        }
        return 0;
        
    }
};

struct stub_pairliststr_search:public pylib::Member_def<vmp::PairList<vmp::str,vmp::str> >
{
    pylib::Objref *def(vmp::PairList<vmp::str,vmp::str> *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str arg0=args.get<vmp::str>(0);
            vmp::str pret;
            vmp_bool ret=instance->search(arg0,&pret);
            pylib::Objref *l=pylib::pylist_new(2);
            pylib::pylist_setitem<vmp_bool>(l,0,ret);
            pylib::pylist_setitem<vmp::str>(l,1,pret);
            return pylib::pylist_astuple(l);
        }
        else
            return 0;
    }
};

struct stub_pairliststr_get:public pylib::Member_def<vmp::PairList<vmp::str,vmp::str> >
{
    pylib::Objref *def(vmp::PairList<vmp::str,vmp::str> *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp_index index=args.get<vmp_index>(0);
            vmp::pair<vmp::str,vmp::str> res=instance->get(index);
            pylib::Objref *l=pylib::pylist_new(2);
            pylib::pylist_setitem<vmp::str>(l,0,res.first);
            pylib::pylist_setitem<vmp::str>(l,1,res.second);
            return pylib::pylist_astuple(l);
        }
        return 0;
    }
};

void vmp_init_pairlist(pylib::Module module)
{
    pylib::Class<vmp::PairList<vmp::str,vmp::str> > pairliststr=module.class_<vmp::PairList<vmp::str,vmp::str> >("PairListStr");
    pairliststr.def_("clear",&vmp::PairList<vmp::str,vmp::str>::clear);
    pairliststr.def_("size",&vmp::PairList<vmp::str,vmp::str>::size);
    pairliststr.def_("insert",&vmp::PairList<vmp::str,vmp::str>::insert);
    pairliststr.def_("update",&vmp::PairList<vmp::str,vmp::str>::update);
    pairliststr.def_("push",&vmp::PairList<vmp::str,vmp::str>::push);
    pairliststr.def_with_stub("cancel",stub_pairliststr_cancel());
    pairliststr.def_("all_keys",&vmp::PairList<vmp::str,vmp::str>::all_keys);
    pairliststr.def_("all_data",&vmp::PairList<vmp::str,vmp::str>::all_data);
    pairliststr.def_("position",&vmp::PairList<vmp::str,vmp::str>::position);
    pairliststr.def_with_stub("search",stub_pairliststr_search());
    pairliststr.def_with_stub("get",stub_pairliststr_get());
}

