#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 04/09/2024

##@package vmp
#
# Wrapper c++ namespace vampiria::vmp

from vmp_ import INTMIN    as INTMIN
from vmp_ import INTMAX    as INTMAX
from vmp_ import INT16MIN  as INT16MIN
from vmp_ import INT16MAX  as INT16MAX
from vmp_ import UINTMIN   as UINTMIN
from vmp_ import UINTMAX   as UINTMAX
from vmp_ import UINT16MIN as UINT16MIN
from vmp_ import UINT16MAX as UINT16MAX
from vmp_ import CHARMIN   as CHARMIN
from vmp_ import CHARMAX   as CHARMAX
from vmp_ import UCHARMIN  as UCHARMIN
from vmp_ import UCHARMAX  as UCHARMAX
from vmp_ import RANDMAX   as RANDMAX
from vmp_ import INT64MIN  as INT64MIN
from vmp_ import INT64MAX  as INT64MAX
from vmp_ import UINT64MIN as UINT64MIN
from vmp_ import UINT64MAX as UINT64MAX

from vmp_ import env as env
from vmp_ import BUFSIZEMAX as BUFSIZEMAX
from vmp_ import Buf as Buf

from vmp_ import except_s     as except_s
from vmp_ import get_errno    as get_errno
from vmp_ import value_errno  as value_errno

from vmp_ import init               as init
from vmp_ import is_debug_mode      as is_debug_mode
from vmp_ import id                 as id
from vmp_ import io_forced_unlock   as io_forced_unlock
from vmp_ import io_recovery_lock   as io_recovery_lock
from vmp_ import debug              as debug
from vmp_ import info               as info
from vmp_ import warning            as warning
from vmp_ import error              as error
from vmp_ import error_raw          as error_raw
from vmp_ import output             as output
from vmp_ import output_raw         as output_raw
from vmp_ import output_file        as output_file
from vmp_ import output_file_lines  as output_file_lines
from vmp_ import input              as input
from vmp_ import input_file         as input_file
from vmp_ import input_file_s       as input_file_s
from vmp_ import exit_ok            as exit_ok
from vmp_ import exit_failure       as exit_failure
from vmp_ import copy_file          as copy_file
from vmp_ import move_file          as move_file

from vmp_ import system_wrap  as system_wrap
from vmp_ import pause_wrap   as pause_wrap
from vmp_ import getpid_wrap  as getpid_wrap
from vmp_ import getuid_wrap  as getuid_wrap
from vmp_ import geteuid_wrap as geteuid_wrap
from vmp_ import kill_wrap    as kill_wrap

from vmp_ import dup2_wrap    as dup2_wrap
from vmp_ import fd_noblock   as fd_noblock
from vmp_ import fd_block     as fd_block
from vmp_ import fd_fsync     as fd_fsync

from vmp_ import srand_wrap   as srand_wrap
from vmp_ import rand_wrap    as rand_wrap  

from vmp_ import Dev_t_wrap   as Dev_t_wrap

from vmp_ import fs           as fs

from vmp_ import signum       as signum
from vmp_ import sigstr       as sigstr
from vmp_ import sigcmp       as sigcmp
from vmp_ import signal_wrap  as signal_wrap

from vmp_ import thread       as thread

from vmp_ import time         as time

from vmp_ import unicode      as unicode

from vmp_ import utils        as utils

from vmp_ import PairListStr  as PairListStr

##Default Global data instance class object
class Data:
  ##A constructor 
  def __init__(self):
    pass
    
##Global instance class 
class Instance:
  ##A constructor  
  def __init__(self):
    self.obj=Data()

  ##set global data object<BR>
  #
  # @param obj global data object  
  def set_global(self,obj):
    self.obj=obj

  ## Returns global data object
  #
  # @return global data object  
  def get_global(self):
    return self.obj

##shared instance class
instance_=Instance()

##input arguments of the process
input_={}

##input function exec<BR>
#
#@param name input name<BR>
#@param f function(parlist,varlist) to exec for any input name
def input_f(name,f):
  try:
    if name in input_:
      ilist=input_[name]
      for value in ilist:
        f(value[0],value[1])
  except Exception as e:
    except_s(str(e))

def external_module_error(name):
  except_s("Python Module \'{0}\' not found,install it.".format(name))

try:
    import signal
except:
    external_module_error("signal")

##native python signal management
#
#@param lsignal signal list in string format(["sigint",...])
#@param sighandler callback signal(def handler(signum, frame))
def signal_py(lsignal,sighandler):
  for s in lsignal:
    try:
      sig=signum(s)
    except Exception as x:
      except_s("Argument 1 error(Invalid input type \'{0}\')".format(str(x))) 
    signal.signal(sig,sighandler)


