#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 19/07/2024

import vmpjlib    as jlib
import vmpsys     as sys
import vmpconfig  as config

##Setup Javascript installer object
class jsetup:
  def __init__(self):
    ##Directory Main
    self.dirmain=None
    ##index file by project.("project name","title page","root tag",[css files list],[javascript file list]) 
    self.index=[]
    ##Internal library or package dependencies ['vmp_net',...](Python).'vmp'is added by default
    self.dependencies=[]
    ##internal usage for create name.html file
    self.csspath=[]
    ##internal usage for create name.html file
    self.jspath=[]
    ##Internal use to avoid entering multiple dependencies of the same type
    self.deprun={}
    ##Internal usage
    self.libpath=""
    
##Build javascript software<BR>
#
#@param setup object setup
def jbuild(jsetup):
  if jsetup.dirmain == None:
    sys.msg_failure("Build Javascript Software","Directory main not setting")  
  jclear(jsetup)
  jsetup.dirmain=config.config_path(jsetup.dirmain)
  jsetup.libpath="{0}{1}".format(jsetup.dirmain,config.jlib_)
  try:
    sys.mkdir(jsetup.libpath)
    sys.config_create("{0}config.js".format(jsetup.libpath),config.configjs_)
    jsetup.jspath.append("{0}config.js".format(config.jlib_))
  except Exception as e:
    sys.msg_failure("Build Javascript Software",str(e))
  jlib.jdependencies(jsetup.dependencies,jsetup)
  try:
    sys.cp_all("{0}{1}".format(config.fwweb_,config.jfavicon_),"{0}{1}".format(jsetup.dirmain,config.jfavicon_))
    for c in jsetup.index[2]:
      jsetup.csspath.append("{0}{1}".format(config.jmain_,c))
    for j in jsetup.index[3]:
      jsetup.jspath.append("{0}{1}".format(config.jmain_,j))
    sys.jsindex_create("{0}index.html".format(jsetup.dirmain),jsetup.index[0],jsetup.index[1],jsetup.csspath,jsetup.jspath)
  except Exception as e:
    sys.msg_failure("Build Javascript Software",str(e))
  sys.msg_ok("Build Javascript Software in dirmain({0})".format(jsetup.dirmain))
  
  
##Clear javascript software<BR>
#
#@param setup object setup 
def jclear(jsetup):
  if jsetup.dirmain != None:
    jsetup.dirmain=config.config_path(jsetup.dirmain)
    jsetup.libpath="{0}{1}".format(jsetup.dirmain,config.jlib_)
    sys.rm_file("{0}{1}".format(jsetup.dirmain,config.jfavicon_))
    if sys.isdir(jsetup.libpath):
      sys.msg_ok("Clear Javascript Software in dirmain({0})".format(jsetup.dirmain))
      sys.rm_dir_all(jsetup.libpath,drem=True)
    sys.rm_file("{0}index.html".format(jsetup.dirmain,))
      
  

