/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/01/2023
 */

#ifndef VAMPIRIA_SOFTWARE_PROCESS_H

#define VAMPIRIA_SOFTWARE_PROCESS_H 1

class Process:public process::Box
{
    public:
       Process(vmp::str id);
       ~Process();

       vmp::str rootdir_;
       vmp_bool is_root_;
       process::BOX_COM comtype_;
       xml::Tag *ptag_;
       vmp::args::Envp envp_;
       
       vmp::str ptype_;//process type(module,software)
       modules::Module *module_;//module process
       vmp::str software_;//software name
       vmp::vector<vmp::str> args_;
       
       vmp::vector<vmp::pair<vmp::str,vmp::str>> exports_;
       vmp::vector<vmp::pair<vmp::str,vmp::str>> kill_;
       vmp::vector<process::StdW *> stdout_;
       vmp::Table<vmp_index,Process *> pout_;
       vmp::Table<vmp::str,vmp_index> pin_;
       vmp::vector<process::StdW *> stderr_;
       
       vmp_index add_stdout(process::StdW *out);
       void add_pout(process::StdW *box,Process *pin);
       void del_stdout(vmp_index i);
       
       vmp_index add_stderr(process::StdW *err);
       void del_stderr(vmp_index i);
       void verify_input();
       
       void run();
};

#endif

