/* -*- Mode:Javascript; javscript-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 27/08/2024
 */
/**
  *Returns the full name of the data type json(example json::'jtype')
  *@param jtype short name data type json
  *@return full name data type json 
*/
function vmp_japi_type(jtype){return `json::${jtype}`;}
/**
  *Returns json type list [subtype] or []
  *@param jtype json type in list("" list not typed)
  *@return list type
*/
function vmp_japi_type_list(jtype=""){return `[${jtype}]`;}
/**
  *Returns json type teble {subtype} or {}
  *@param jtype json type in table("" table not typed)
  *@return table type
*/
function vmp_japi_type_table(jtype=""){return `{${jtype}}`;}
/**
  *Create a json data json::japi("void")
  <pre>
  { 
    jtype: json::japi("void"),
    jbody: {}
  }
  </pre>
*/
function vmp_japi_void()
{
  let ret=new Vmp_JData();
  ret.new_data(vmp_japi_type("void"));
  return ret;
}
/**
  *Create a json data json::japi("[datatype]") or json::japi("[]") for generic list
  <pre>
  {
    jtype: json::japi("[datatype]"),
    jbody:
    {
      datatype:'datatype',
      list: 'list'
    }
    }
  </pre>
  *@param list {Array of Vmp_JData} array list
  *@param datatype jdata types in the list
  *@throws in case of failure
*/
function vmp_japi_list(list,datatype="")
{
  let ret=new Vmp_JData();
  for(let obj of list)
  {
    if (!(obj instanceof Vmp_JData))
      vmp_except(`japi_list(list=bad values)`);
  }
  ret.new_data(vmp_japi_type_list(datatype));
  ret.setjbody(
  {
    datatype:datatype,
    list:list,
  });
  return ret; 
}
/**
  *Create a json data {'datatype'} or "{}" for generic table
  <pre>
  {
    jtype: {'datatype'}, 
    jbody:
    {
      datatype:'datatype',
      table:'table'
    }
    </pre>
    @param table {Object of Vmp_JData} table object
    @param datatype jdata types in the table
*/
function japi_table(table,datatype="")
{
  let ret=new Vmp_JData();
  ret.new_data(vmp_japi_type_table(datatype));
  try
  {
    for(let key in table)
    {
      if(!(table[key] instanceof Vmp_JData))
        vmp_except("");
    }
  }
  catch(error)
  {
    vmp_except(`japi_table(table=bad values)`);
  }
  ret.new_data(vmp_japi_type_table(datatype));
  ret.setjbody(
  {
    datatype:datatype,
    table:table,
  });
  return ret; 
}
/**
  *Create a json data json::japi("status") used to request information about your status at a process
  <pre>
  { 
    jtype: json::japi("status"),
    jbody: 
       {
           id:'id'
       }
    }
   </pre>
   @param id requested Status ID 
*/
function vmp_japi_status(id="")
{
  let ret=new Vmp_JData();
  ret.new_data(vmp_japi_type("status"));
  ret.setjbody({id:id});
  return ret;
}
/**
  *Create a json data login
  *@param user {string} user field
  *@param password {string} password field
  *@param md5_password {boolean} if true password is encrypted in md5
*/
function vmp_japi_login(user,password,md5_password=false) 
{
  let ret=new Vmp_JData();
  ret.new_data(vmp_japi_type("login"))
  let jbody=ret.jbody();
  jbody.user=user;
  jbody.password=password;
  jbody.md5_password=md5_password;
  return ret;
}

