/* -*- Mode:Javascript; javscript-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 27/08/2024
 */
 /**Transform an element div into a vmp_component div */
class Vmp_Cmp_Div extends vmp_component(HTMLDivElement){constructor(){super();}};
/**Transform an element table into a vmp_component table */
class Vmp_Cmp_Table extends vmp_component(HTMLTableElement){constructor(){super();}};
/**Component that includes a push button with each button corresponding to a view */
class Vmp_Cmp_Container extends vmp_component(HTMLDivElement)
{
  /**constructor*/
  constructor()
  {
    super();
    this.style.setProperty("width","100%");
    this.table_=vmp_wrap_map();
    this.buttons_=vmp_wrap_createElement("vmp-div",'div');
    this.buttons_.style.setProperty("text-align","left"); 
    this.buttons_.style.setProperty("font-size",vmp_rootvar("--font-size-small"));
    this.buttons_.style.setProperty("margin-top",vmp_rootvar("--session-margin-element"));
    this.buttons_.style.setProperty("margin-bottom",vmp_rootvar("--session-margin-element"));
    this.childInsert(this.buttons_,0);
  }
  /**reset component*/
  reset(){this.table_.clear();this.buttons_.innerHTML="";this.childRemove(1);}
  /**
    *Adds a button and the corresponding view
    *@param name {String} view name
    *@param tag {tag} tag corresponding to the view
  */
  add_page(name,tag)
  {
    if(!this.table_.has(name))
    {
      let b=vmp_wrap_createElement("button");
      b.style.setProperty("margin",vmp_rootvar("--main-button-margin"));
      b.style.setProperty("color",vmp_rootvar("--font-color"));
      b.style.setProperty("width",vmp_rootvar("100px"));
      b.setAttribute("data-name",name);
      b.addEventListener("click",this.clickme.bind(this));
      b.innerHTML=name;
      if(this.table_.size === 0)
      {
        b.style.setProperty("cursor",vmp_rootvar("--cursor-unpointer"));
        b.style.setProperty("background-color",vmp_rootvar("--background-color-main"));
        b.disabled=true;
        this.childInsert(tag,1);
      }
      else
      {
        b.style.setProperty("cursor",vmp_rootvar("--cursor-pointer"));
        b.style.setProperty("background-color",vmp_rootvar("--background-color-bar"));
        if((this.table_.size % 7) === 0)
          this.buttons_.appendChild(vmp_wrap_createElement("br"));
      }
      this.buttons_.appendChild(b);
      this.table_.set(name,[b,tag]);
    }
    else
    {
      let entry=this.table_.get(name);
      this.table_.set(name,[entry[0],tag]);
    }
    
  }
  /**internal usage*/
  clickme(e)
  {
    let target=e.target;
    let name=target.getAttribute("data-name");
    for(let entry of this.table_)
    {
      if(entry[0] != name)
      {
        entry[1][0].style.setProperty("cursor",vmp_rootvar("--cursor-pointer"));
        entry[1][0].style.setProperty("background-color",vmp_rootvar("--background-color-bar"));
        entry[1][0].disabled=false;
      }
      else
      {
        entry[1][0].disabled=true;
        entry[1][0].style.setProperty("cursor",vmp_rootvar("--cursor-unpointer"));
        entry[1][0].style.setProperty("background-color",vmp_rootvar("--background-color-main"));  
        this.childReplace(entry[1][1],1);
      }
    }
  }
};
/**A component that represents a list of objects (one for each row in the table)*/
class Vmp_Cmp_list extends vmp_component(HTMLTableElement)
{
  /**A constructor*/
  constructor()
  {
    super();
    /**
     *table lines associated with keys
     *@type {Map}
     *@public
    */
    this.lines_=new vmp_wrap_map();
    this.setAttribute("class","vmp_list");
  }
  /**
    *init new object type list
    *@param cols {Object} Objects with fields {name:"column name",width:"larghezza colonna"(default notr assigned),order:Can the data be sorted?(default false)}
  */
  init(...cols)
  {
    this.thead_=this.createTHead();
    this.reset();
    let name,order,i=0,col;
    let row=this.thead_.insertRow(0);
    for(let c of cols)
    {
       if(c.name != undefined)
       {
         name=c.name;
         order=(!vmp_isbool(c.order))?false:c.order;
         col=vmp_wrap_createElement('th');
         col.setAttribute("class",'vmp_list_h');
         if(c.width != undefined)col.setAttribute('width',c.width);
         col.innerHTML=name;
         if(order)
         {
           if(this.index_ === -1)
           {  
             this.index_=i;
             this.order_="inc";
           }
           col.style.setProperty("cursor",vmp_rootvar("--cursor-pointer"));
           col.setAttribute("data-index",i);
           col.addEventListener("click",this.clickme.bind(this));
         }
         row.appendChild(col);
         i++;
      }
    }
    this.ncols_=i;
    this.order();
  }
  /**Internal usage*/
  clickme(e)
  {
    let i=Number(e.target.getAttribute('data-index'));
    if(i == this.index_)this.order_=(this.order_ === "inc")?"dec":"inc";
    else this.index_=i;
    this.order();
  }
  /**
    *Inserts a line in the list
    *@param key {string} key data
    *@param data {Array} data entered
  */
  insert(key,data)
  {
    this.cancel(key);
    let row=this.tBodies[0].insertRow(0);
    let i=0;
    for(let d of data)
    {
      if(i<this.ncols_)
      {
        let col=row.insertCell(i);
        try
        {
          col.appendChild(d);
        }
        catch(e)
        {
          col.innerHTML=d;
        }
        col.setAttribute("class","vmp_list_d");
      }
      else
        break;
      i++;
    }
    while(i<this.ncols_)
    {
      let col=row.insertCell(i++);
      col.setAttribute("class","vmp_list_d");
    }
    this.lines_.set(key,row);
    this.order(); 
  }
  /**
    *Delete a line from the list
    *@param key {string} key data
  */
  cancel(key)
  {
    let row=this.lines_.get(key);
    if(row != undefined)
    {
      row.remove();
      this.lines_.delete(key);
    }  
  }
  /**Internal usage*/
  order()
  {
    if(this.index_ >= 0)
    {
      let sortedRows;
      if(this.order_ == "inc")
        sortedRows = Array.from(this.tBodies[0].rows).sort((rowA,rowB)=>rowA.cells[this.index_].innerHTML.localeCompare(rowB.cells[this.index_].innerHTML));
      else
         sortedRows = Array.from(this.tBodies[0].rows).sort((rowA, rowB) =>-rowA.cells[this.index_].innerHTML.localeCompare(rowB.cells[this.index_].innerHTML));
      this.tBodies[0].append(...sortedRows);
    }
  }
  /**Reset object list*/
  reset()
  {
    this.createTBody();
    this.map_=vmp_wrap_map();
    this.index_=-1;
    this.order_="";
  }
};

/**Virtual class interface for websocket login (see Vmp_Cmp_Main)**/
class Vmp_Cmp_Login_I extends vmp_component(HTMLDivElement)
{
  /**constructor**/
  constructor()
  {
    super();
    /**
     *Input user name element 
     *@type {element}
     *@public
    */
    this.input_username_=vmp_wrap_createElement('input');
    this.input_username_.setAttribute("type","text");
    this.input_username_.setAttribute("placeholder","Enter username");
    this.input_username_.setAttribute("name","username");
    this.input_username_.setAttribute("required","");
    this.input_username_.setAttribute("size","25");
    /**
     *Input user name element 
     *@type {element}
     *@public
    */
    this.input_password_=vmp_wrap_createElement('input');
    this.input_password_.setAttribute("type","password");
    this.input_password_.setAttribute("placeholder","Enter password");
    this.input_password_.setAttribute("name","password");
    this.input_password_.setAttribute("size","25");
    /**
     *login button element
     *@type {element}
     *@public
    */
    this.blogin_=vmp_wrap_createElement('input');
    this.blogin_.setAttribute("class","vmp_login_button");
    this.blogin_.setAttribute("type","button");
    this.blogin_.setAttribute("value","Login");
    this.blogin_.addEventListener("click",this.login.bind(this));
    /**
     *reset button element
     *@type {element}
     *@public
    */
    this.breset_=vmp_wrap_createElement('input');
    this.breset_.setAttribute("class","vmp_login_button");
    this.breset_.setAttribute("type","button");
    this.breset_.setAttribute("value","Reset");
    this.breset_.addEventListener("click",(e)=>{this.input_username_.value='';this.input_password_.value='';});
  }
  /**Event called to log in */
  login(event)
  {
    if(this.input_username_.value != "")
    {
      window.main_.connect(this.url(event),this.input_username_.value);
      this.input_password_.value='';
    }
    else
      vmp_wrap_alert("Input login empty!!!!");
  }
  /**Generate the url to connect the websocket  */
  url(event){vmp_wrap_alert("Vmp_Cmp_Login_I.url() not implemented");}
}
/**Virtual class interface wait for an operation before continuing(see Vmp_Cmp_Main)**/
class Vmp_Cmp_Waiting_I extends vmp_component(HTMLDivElement)
{
  /**constructor*/
  constructor()
  {
    super();
    /**
     *waiting timer
     *@type {cmp}
     *@public
    */
    this.timer_=new Vmp_Timeout();
  }
  /**
   *Active Component of waiting,if the timeout is triggered, it closes the connection
   *@param msg {String} information message
   *@param timeout {Number} timeout in ms
  */
  start(msg,timeout)
  {
    this.timer_.start(()=>{vmp_wrap_alert(`Timeout:${msg}`);window.main_.timeout(msg);},timeout);
    this.view(`${msg}...`);
  }
  /**end waiting*/
  stop(){this.timer_.stop();}
  
  /**
    *set the display of the message
    *@param msg {String} message display
  */
  view(msg){vmp_wrap_alert("Vmp_Cmp_Waiting_I.view() not implemented");}
}
/**Virtual class to implement the component activated when the login has been made and the program is running(see Vmp_Cmp_Main)
**/
class Vmp_Cmp_Session_I extends vmp_component(HTMLDivElement)
{
  /**constructor*/
  constructor()
  {
    super();
    /**
     *actions table
     *@type {cmp}
     *@public
    */
    this.actions_=vmp_wrap_map();
  }
  /**
    *virtual function add action
    *@param name {string} action name
    *@param text {string} text label
    *@param cb {callback} callback callback call when event is activated
    *@param img {element} image label
  */
  add_action(name,text,cb,img=null){vmp_wrap_alert("Vmp_Cmp_Run_I.add_action() not implemented");}
  
  /** 
    *virtual function active and disactive action
    *@param name {string} action name
    *@param value {bool} true active,false disactive
  */
  run_action(name,value){vmp_wrap_alert("Vmp_Cmp_Run_I.run_action() not implemented");}
  /** 
    *view component
    *@param cmp {component} component to view
  */
  set_view(cmp){vmp_wrap_alert("Vmp_Cmp_Run_I.set_view() not implemented");}
  /**reset session*/
  reset(){}
}
/**
  *The default component for websocket login(see Vmp_Cmp_Main)
  *@extends Vmp_Cmp_Login_I
*/
class Vmp_Cmp_Login extends Vmp_Cmp_Login_I
{
  /**constructor*/
  constructor()
  {
    super();
    this.setAttribute("class","vmp_login_root");
    /**
     *logo img 
     *@type {element}
     *@public
    */
    this.logo_=vmp_wrap_createElement('img');
    this.logo_.setAttribute("class",'vmp_login_logo');
    this.logo_.setAttribute("src",'lib/img/ragnu.jpg');
    this.logo_.setAttribute("alt","ragnu logo");
    this.appendChild(this.logo_);
    /**
     *logo tag title 
     *@type {element}
     *@public
    */
    this.title_=vmp_wrap_createElement('h2');
    this.title_.innerHTML=document.title;
    this.appendChild(this.title_);
     /**
     *login container
     *@type {element}
     *@public
    */
    this.container_=vmp_wrap_createElement('div');
    this.container_.setAttribute("class","vmp_login_container");
    this.appendChild(this.container_);
    /**
     *label element for username 
     *@type {element}
     *@public
    */
    this.label_username_=vmp_wrap_createElement('label');
    this.label_username_.setAttribute("for",'username');
    let b=vmp_wrap_createElement('b');
    b.appendChild(vmp_wrap_createTextNode("Username:"));
    this.label_username_.appendChild(b);
    this.container_.appendChild(this.label_username_);
    this.container_.appendChild(vmp_wrap_createElement('br'));
    this.container_.appendChild(this.input_username_);
    this.container_.appendChild(vmp_wrap_createElement('br'));
    this.container_.appendChild(vmp_wrap_createElement('br'));
    /**
     *label element for password 
     *@type {element}
     *@publictag.disabled
    */
    this.label_password_=vmp_wrap_createElement('label');
    this.label_password_.setAttribute("for",'password');
    b=vmp_wrap_createElement('b');
    b.appendChild(vmp_wrap_createTextNode("Password:"));
    this.label_password_.appendChild(b);
    this.container_.appendChild(this.label_password_);
    this.container_.appendChild(vmp_wrap_createElement('br'));
    this.container_.appendChild(this.input_password_);
    this.container_.appendChild(vmp_wrap_createElement('br'));
    this.container_.appendChild(vmp_wrap_createElement('br'));
    /**
     *button container 
     *@type {element}
     *@public
    */
    this.bcontainer_=vmp_wrap_createElement('div');
    this.bcontainer_.setAttribute("class","vmp_login_bar");
    this.appendChild(this.bcontainer_);
    this.bcontainer_.appendChild(this.blogin_);
    this.bcontainer_.appendChild(this.breset_);
  }
  /**virtual function*/
  url(event)
  {
    let data=vmp_japi_login(this.input_username_.value,this.input_password_.value);
    if(window.location.port == '')
      return `wss://${window.location.hostname}/login?auth-token=${vmp_wrap_base64_encode(vmp_wrap_json_stringify(data.obj_))}`
    return `wss://${window.location.hostname}:${window.location.port}/login?auth-token=${vmp_wrap_base64_encode(vmp_wrap_json_stringify(data.obj_))}`
  }
}
/**
  *The default component wait for an operation before continuing(see Vmp_Cmp_Main)
  *@extends Vmp_Cmp_Waiting_I
*/
class Vmp_Cmp_Waiting extends Vmp_Cmp_Waiting_I
{
  /**constructor*/
  constructor()
  {
    super();
    this.setAttribute("class","vmp_waiting_root");
    this.text_=vmp_wrap_createElement('p');
    this.text_.innerHTML='waiting...';
    this.clessidra_=vmp_wrap_createElement('img');
    this.clessidra_.setAttribute("class",'vmp_waiting_img');
    this.clessidra_.setAttribute("src",'lib/img/clessidra43.gif');
    this.clessidra_.setAttribute("alt","clessidra 43");
    this.table_=vmp_wrap_createElement('vmp-table','table');
    this.row_=vmp_wrap_createElement('tr');
    let td=vmp_wrap_createElement('td');
    td.appendChild(this.text_);
    this.row_.appendChild(td);
    td=vmp_wrap_createElement('td');
    td.appendChild(this.clessidra_);
    this.row_.appendChild(td);
    this.table_.appendChild(this.row_);
    this.appendChild(this.table_);
  }
  /**virtual function*/
  view(msg){this.text_.innerHTML=`${msg}...`;}
}
/**
  *The default component activated when the login has been made and the program is running(see Vmp_Cmp_Main)
  *@extends Vmp_Cmp_Session_I
**/
class Vmp_Cmp_Session extends Vmp_Cmp_Session_I
{
  constructor()
  {
    super();
    this.setAttribute("class","vmp_session_root");
    this.bar_=vmp_wrap_createElement('vmp-div','div');
    this.bar_.setAttribute("class","vmp_session_bar");
    this.body_=vmp_wrap_createElement('vmp-div','div');
    this.body_.setAttribute("class","vmp_session_body");
    this.footer_=vmp_wrap_createElement('vmp-div','div');
    this.footer_.setAttribute("class","vmp_session_footer");
    this.footer_.innerHTML=`<center><i>author:${vmp_env_author()},email:${vmp_env_email()},webpage:${vmp_env_webpage()}</i></center>`;
    this.childInsert(this.bar_,0);
    this.childInsert(this.body_,1);
    this.childInsert(this.footer_,2);
  }
  /**virtual function*/
  add_action(name,text,cb,img=null)
  {
    if(this.actions_.has(name))vmp_except(`Vmp_Cmp_Run_I.add_button(name=${name})`);
    let button=vmp_wrap_createElement('button');
    button.setAttribute("class","vmp_session_button");
    if(img == null)button.innerHTML=text;
    else {button.innerHTML=`<img src='${img}' alt='${text}' height=12 width=12 />`}
    button.addEventListener("click",cb);
    this.actions_.set(name,button);
    this.bar_.appendChild(button);
    return button; 
  }
  /**virtual function*/
  run_action(name,value)
  {
    let tag=this.actions_.get(name);
    if(tag != undefined)
    {
      tag.disabled=!value;
      tag.style.setProperty("cursor",vmp_rootvar((value)?"--cursor-pointer":"--cursor-unpointer"));
    }
  }
  /**virtual function*/
  set_view(cmp)
  {
    if(cmp == null)
      this.body_.childRemove(0);
    else
      this.body_.childReplace(cmp,0);
  }
  /**virtual function*/
  reset(){this.set_view(null);}
}
/**
  *The default component JRP and session message management class(see Vmp_Cmp_Main)
  *@extends Vmp_Jrp_Manager_I
**/
class Vmp_Cmp_Manager extends Vmp_Jrp_Manager_I
{
  /**constructor*/
  constructor()
  {
    super();
    this.head_=vmp_wrap_createElement("vmp-table",'table');
    this.head_.setAttribute("width","100%");
    let tr1=this.head_.insertRow(0);
    let tr2=this.head_.insertRow(1);
    let tr3=this.head_.insertRow(2);
    let tr4=this.head_.insertRow(3);
    this.logo_=tr1.insertCell(0);
    this.logo_.setAttribute("rowspan","3");
    this.logo_.innerHTML=`<center><img src='lib/img/ragnu.jpg' width='${vmp_rootvar('--session-logo-width')}' height='${vmp_rootvar('--session-logo-height')}' alt='logo' /></center>`;
    let td=tr1.insertCell(1);
    td.innerHTML="user:";
    this.tuser_=tr1.insertCell(2);
    td=tr2.insertCell(0);
    td.innerHTML="permits:";
    this.tpermits_=tr2.insertCell(1);
    td=tr3.insertCell(0);
    td.innerHTML="Nodetype:";
    this.tnodetype_=tr3.insertCell(1);
    td=tr4.insertCell(0);
    td.innerHTML="<center><strong>System management</strong></center>";
    this.appendChild(this.head_);
    this.body_=vmp_wrap_createElement("vmp-container",'div');
    this.appendChild(this.body_);
  }
  /**Virtual function called on session opening*/
  session_impl()
  {
    this.tuser_.innerHTML=this.user_;
    this.tpermits_.innerHTML=this.permits_;
    this.tnodetype_.innerHTML=this.nodetype_;
    this.session_=vmp_wrap_createElement("vmp-div",'div');
    let title=vmp_wrap_createElement("h3");
    title.innerHTML="Request input";
    this.session_.appendChild(title);
    this.session_req_=vmp_wrap_createElement("vmp-list",'table');
    this.session_req_.init({name:'input',order:true,width:'25%'},{name:'response',width:'25%'},{name:'push',width:'25%'},{name:'permits',width:'25%'});
    for(let r in this.reqdata_)
    {
      let response=vmp_wrap_createElement("div"),push=vmp_wrap_createElement("div");
      let i=0;
      for(let tmp of this.reqdata_[r].response)
      {
        if(i != 0)
          response.appendChild(vmp_wrap_createElement("br"));
        response.appendChild(vmp_wrap_createTextNode(tmp));
        i++; 
      }
      i=0;
      for(let tmp of this.reqdata_[r].push)
      {
        if(i != 0)
          push.appendChild(vmp_wrap_createElement("br"));
        push.appendChild(vmp_wrap_createTextNode(tmp));
        i++; 
      }
      this.session_req_.insert(r,[r,response,push,this.reqdata_[r].permits]);
    }
    this.session_.appendChild(this.session_req_);
    title=vmp_wrap_createElement("h3");
    title.innerHTML="Broadcast message";
    this.session_.appendChild(title);
    this.session_broad_=vmp_wrap_createElement("vmp-list",'table');
    this.session_broad_.init({name:'input',order:true,width:'25%'},{name:'',order:false,width:'75%'})
    for(let tmp of this.bdata_)
      this.session_broad.insert(tmp,[tmp,'']);
    this.session_.appendChild(this.session_broad_);
    this.body_.add_page("Session",this.session_);
    this.requests_=vmp_wrap_createElement("vmp-div",'div');
    title=vmp_wrap_createElement("h3");
    title.innerHTML="Request Manager";
    this.requests_.appendChild(title);
    this.reqmanager_=vmp_wrap_createElement("vmp-list",'table');
    this.reqmanager_.init({name:'rid',order:true,width:'6%'},{name:'component',order:true,width:'17%'},{name:'request jdata',order:true,width:'17%'},{name:'forward',order:true,width:'18%'},{name:'status',order:true,width:'6%'},{name:'exit code',order:true,width:'17%'},{name:'exit message',order:true,width:'17%'},{name:'kill',width:'6%'});
    this.requests_.appendChild(this.reqmanager_);
    this.body_.add_page("Requests",this.requests_);
  }
  /**Virtual function called on session end*/
  session_close_impl()
  {
    this.tuser_.innerHTML="";
    this.tpermits_.innerHTML="";
    this.tnodetype_.innerHTML="";
    this.body_.reset();
  }
  /**Virtual function called on request*/
  update_request(req)
  {
    if(req.status_ === "open")
    {
      let k=vmp_wrap_createElement('button');
      k.setAttribute("class","vmp_manager_kill");
      let s=vmp_rootvar("--font-size-small");
      k.setAttribute("data-rid",req.rid_);
      k.innerHTML=`<img src='lib/img/close.png' alt='kill ${req.rid_}' data-rid='${req.rid_}' height=${s} width=${s} />`;
      k.addEventListener("click",this.kill_req.bind(this));
      this.reqmanager_.insert(req.rid_,[req.rid_,req.cmp_.cmpid_,req.jdata_.jtype(),req.forward_,req.status_,req.close_status_,req.close_msg_,k]);
    }
    else
      this.reqmanager_.insert(req.rid_,[req.rid_,req.cmp_.cmpid_,req.jdata_.jtype(),req.forward_,req.status_,req.close_status_,req.close_msg_]);
  }
  /**Internal usage*/
  kill_req(e)
  {
    let rid=e.target.getAttribute('data-rid');
    let req=this.table_.get(Number(rid));
    console.log(`send kill ${rid}`);
    req.kill();
  }
};
try
{
  vmp_wrap_define("vmp-div",Vmp_Cmp_Div,'div');
  vmp_wrap_define("vmp-table",Vmp_Cmp_Table,'table');
  vmp_wrap_define("vmp-container",Vmp_Cmp_Container,'div');
  vmp_wrap_define("vmp-list",Vmp_Cmp_list,'table');
  vmp_wrap_define("vmp-login",Vmp_Cmp_Login,'div');
  vmp_wrap_define("vmp-waiting",Vmp_Cmp_Waiting,'div');
  vmp_wrap_define("vmp-session",Vmp_Cmp_Session,'div');
  vmp_wrap_define("vmp-manager",Vmp_Cmp_Manager,'div');
}
catch(error)
{
  vmp_wrap_alert(error);
}

