/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/05/2024
 */

#include "vmp.h"

namespace vampiria { namespace vmp {

void ioctl_wrap_ifreq(vmp_int fd,vmp::str name,vmp_uint request,struct ifreq *ifr)
{
    vmp::strncpy_wrap(ifr->ifr_name,name.c_str(),IFNAMSIZ-1);
    if(ioctl(fd,request,ifr) == -1)
        vmp::except_errno();
}

Dev_t_wrap::Dev_t_wrap()
{
    set_values(0,0);
}

Dev_t_wrap::~Dev_t_wrap()
{
}

void Dev_t_wrap::set_values(vmp_uint major,vmp_uint minor)
{
    major_=major;
    minor_=minor;
}

void Dev_t_wrap::set(dev_t dev)
{
    major_=major(dev);
    minor_=minor(dev);
}

vmp_uint Dev_t_wrap::get_major()
{
    return major_;
}

vmp_uint Dev_t_wrap::get_minor()
{
    return minor_;
}
        
dev_t Dev_t_wrap::get_dev()
{
    return makedev(major_,minor_);
}

}}

