/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 06/02/2020
 */

#ifndef VAMPIRIA_PYLIB_TYPEINFO_H

#define VAMPIRIA_PYLIB_TYPEINFO_H 1

namespace vampiria { namespace pylib {

template<typename T>
struct is_pointer 
{ 
    static const vmp_bool value_ = false;
    static vmp_bool is_null(T value)
    {
          return false;
    }
};

template<typename T>
struct is_pointer<T*> 
{ 
    static const vmp_bool value_ = true;
    static vmp_bool is_null(T *value)
    {
         if(value == 0)
              return true;
         return false;
    }
};

template<typename T>
struct is_vector 
{ 
    static const vmp_bool value_ = false;
    
    static pylib::Objref *Converter(T value,vmp_bool retfree)
    {
        return 0;
    }

    static T arg_from_python(pylib::Objref *obj)
    {
        return pylib::arg_from_python<T>(obj);
    }
};

template<typename T>
struct is_vector<vmp::vector<T> > 
{ 
    static const vmp_bool value_ = true;
    
    static pylib::Objref *Converter(vmp::vector<T> value,vmp_bool retfree)
    {
        pylib::Objref *ret=pylib::pylist_new(value.size());
        for(vmp_index i=0;i<value.size();i++)
            pylib::pylist_setitem<T>(ret,i,value[i],retfree);
        return ret;
    }

    static vmp::vector<T> arg_from_python(pylib::Objref *obj)
    {
        vmp::vector<T> ret;
        if(pylib::pytuple_check(obj))
        {
            for(vmp_index i=0;i<pylib::pytuple_size(obj);i++)
               ret.push_back(pylib::arg_from_python<T>(pylib::pytuple_getitem(obj,i)));
            return ret;
        }
        else if (pylib::pylist_check(obj))
        {
            for(vmp_index i=0;i<pylib::pylist_size(obj);i++)
               ret.push_back(pylib::arg_from_python<T>(pylib::pylist_getitem(obj,i)));
            return ret;
        }
        vmp::except_s("arg_from_python invalid arguments type");
        return ret;
    }
};

struct type_info
{
    inline type_info(vmp::type_info const& = typeid(void));
    
    inline vmp_bool operator<(type_info const& rhs) const;
    inline vmp_bool operator==(type_info const& rhs) const;

    vmp_char const* name() const;
  
    private: // data members
        typedef vmp::type_info const *base_id_t;
    
        base_id_t base_type_;
};

template <class T>
inline pylib::type_info type_id()
{
    return pylib::type_info(typeid(T));
}

template <class T>
inline pylib::type_info unwrap_type_id(T*)
{
    return pylib::type_id<T>();
}

template <class T>
inline pylib::type_info unwrap_type_id(T)
{
    return pylib::type_id<T>();
}

inline type_info::type_info(vmp::type_info const& id)
    : base_type_(&id)
{
}

inline bool type_info::operator<(pylib::type_info const& rhs) const
{
    return base_type_->before(*rhs.base_type_);
}

inline bool type_info::operator==(pylib::type_info const& rhs) const
{
    return *base_type_ == *rhs.base_type_; 
}

inline vmp_char const* type_info::name() const
{
    char const* raw_name=base_type_->name();
    return raw_name;
}

}}

#endif

