/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 03/09/2024
 */

#include "http/protocol.h"

#ifndef VAMPIRIA_PACKET_HTTP_H

#define VAMPIRIA_PACKET_HTTP_H 1

namespace vampiria { namespace packet { namespace http {

//! Header http request
class Http_Request_P:public packet::Packet
{
    public:
        //! A constructor
        Http_Request_P();

        //! A destructor
        ~Http_Request_P();
        
        //! virtual function
        void read(vmp::Buf *buf);

        //! virtual function
        void write(vmp::Buf *buf);
        
        //! virtual function
        vmp::str print();
        
        //!Internal usage
        void set_uri(packet::http::UriHelper *uri);
        
        //!Internal usage
        void set_headers(packet::http::HeadersHelper *headers);
};

//! Header http request
class Http_Response_P:public packet::Packet
{
    public:
        //! A constructor
        Http_Response_P();

        //! A destructor
        ~Http_Response_P();
        
        //! virtual function
        void read(vmp::Buf *buf);

        //! virtual function
        void write(vmp::Buf *buf);
        
        //! virtual function
        vmp::str print();
        
        //!
        vmp_uint get_code();
        void set_code(vmp_int code);
        
        //! Internal usage
        void set_headers(packet::http::HeadersHelper *headers);
};

}}}

#endif

